/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.context;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.internal.macro.MacroContentParser;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.context.ContextMacroParameters;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="context")
@Singleton
public class ContextMacro
extends AbstractMacro<ContextMacroParameters> {
    private static final String DESCRIPTION = "Executes content in the context of the passed document";
    private static final String CONTENT_DESCRIPTION = "The content to execute";
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private MacroContentParser contentParser;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> currentDocumentReferenceResolver;

    public ContextMacro() {
        super("Context", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION), ContextMacroParameters.class);
        this.setPriority(10);
        this.setDefaultCategory("Development");
    }

    public boolean supportsInlineMode() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Block> execute(ContextMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        List<Block> result;
        if (parameters.getDocument() == null) {
            throw new MacroExecutionException("You must specify a 'document' parameter pointing to the document to set in the context as the current document.");
        }
        DocumentReference docReference = this.currentDocumentReferenceResolver.resolve((Object)parameters.getDocument(), new Object[0]);
        boolean currentContextHasProgrammingRights = this.documentAccessBridge.hasProgrammingRights();
        try {
            HashMap backupObjects = new HashMap();
            try {
                this.documentAccessBridge.pushDocumentInContext(backupObjects, docReference);
                if (this.documentAccessBridge.hasProgrammingRights() && !currentContextHasProgrammingRights) {
                    throw new MacroExecutionException("Current document must have programming rights since the context document provided [" + parameters.getDocument() + "] has programming rights.");
                }
                result = this.contentParser.parse(content, context, true, false);
            }
            finally {
                this.documentAccessBridge.popDocumentFromContext(backupObjects);
            }
        }
        catch (Exception e) {
            if (e instanceof MacroExecutionException) {
                throw (MacroExecutionException)e;
            }
            throw new MacroExecutionException("Failed to render page in the context of [" + docReference + "]", (Throwable)e);
        }
        result = Arrays.asList(new MetaDataBlock((List)result, "source", (Object)parameters.getDocument()));
        return result;
    }
}

