/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.gallery;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.internal.macro.MacroContentParser;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.skinx.SkinExtension;

@Component
@Named(value="gallery")
@Singleton
public class DefaultGalleryMacro
extends AbstractMacro<Object> {
    private static final String DESCRIPTION = "Displays the images found in the provided content using a slide-show view.";
    private static final String CONTENT_DESCRIPTION = "The images to be displayed in the gallery. All the images found in the provided wiki content are included. Images should be specified using the syntax of the current document. Example, for XWiki 2.0 syntax: image:Space.Page@alice.png image:http://www.example.com/path/to/bob.jpg";
    @Inject
    private MacroContentParser contentParser;
    @Inject
    @Named(value="jsfx")
    private SkinExtension jsfx;
    @Inject
    @Named(value="ssfx")
    private SkinExtension ssfx;

    public DefaultGalleryMacro() {
        super("Gallery", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION));
        this.setDefaultCategory("Formatting");
    }

    public List<Block> execute(Object parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        if (context != null) {
            Map<String, Boolean> skinExtensionParameters = Collections.singletonMap("forceSkinAction", true);
            this.jsfx.use("uicomponents/widgets/gallery/gallery.js", skinExtensionParameters);
            this.ssfx.use("uicomponents/widgets/gallery/gallery.css", skinExtensionParameters);
            GroupBlock galleryBlock = new GroupBlock(Collections.singletonMap("class", "gallery"));
            galleryBlock.addChildren(this.contentParser.parse(content, context, false, false));
            return Collections.singletonList(galleryBlock);
        }
        return Collections.emptyList();
    }

    public boolean supportsInlineMode() {
        return false;
    }
}

