/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.include;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.display.internal.DocumentDisplayerParameters;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.properties.BeanManager;
import org.xwiki.properties.PropertyException;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroMarkerBlock;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.internal.macro.include.AbstractIncludeMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.include.IncludeMacroParameters;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="include")
@Singleton
public class IncludeMacro
extends AbstractIncludeMacro<IncludeMacroParameters> {
    private static final String DESCRIPTION = "Include other pages into the current page.";
    @Inject
    private BeanManager beans;

    public IncludeMacro() {
        super("Include", DESCRIPTION, IncludeMacroParameters.class);
        this.setPriority(10);
        this.setDefaultCategory("Content");
    }

    public boolean supportsInlineMode() {
        return true;
    }

    public List<Block> execute(IncludeMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        XDOM result;
        DocumentModelBridge documentBridge;
        EntityReference includedReference = this.resolve(context.getCurrentMacroBlock(), parameters.getReference(), parameters.getType(), "include");
        this.checkRecursion((Block)context.getCurrentMacroBlock(), includedReference);
        try {
            documentBridge = this.documentAccessBridge.getDocumentInstance(includedReference);
        }
        catch (Exception e) {
            throw new MacroExecutionException("Failed to load Document [" + (String)this.defaultEntityReferenceSerializer.serialize(includedReference, new Object[0]) + "]", (Throwable)e);
        }
        if (!this.authorization.hasAccess(Right.VIEW, (EntityReference)documentBridge.getDocumentReference())) {
            throw new MacroExecutionException(String.format("Current user [%s] doesn't have view rights on document [%s]", this.documentAccessBridge.getCurrentUserReference(), includedReference));
        }
        IncludeMacroParameters.Context parametersContext = parameters.getContext();
        DocumentDisplayerParameters displayParameters = new DocumentDisplayerParameters();
        displayParameters.setContentTransformed(parametersContext == IncludeMacroParameters.Context.NEW);
        displayParameters.setExecutionContextIsolated(displayParameters.isContentTransformed());
        displayParameters.setSectionId(parameters.getSection());
        displayParameters.setTransformationContextIsolated(displayParameters.isContentTransformed());
        displayParameters.setTransformationContextRestricted(context.getTransformationContext().isRestricted());
        displayParameters.setTargetSyntax(context.getTransformationContext().getTargetSyntax());
        displayParameters.setContentTranslated(true);
        Stack<EntityReference> references = (Stack<EntityReference>)this.macrosBeingExecuted.get();
        if (parametersContext == IncludeMacroParameters.Context.NEW) {
            if (references == null) {
                references = new Stack<EntityReference>();
                this.macrosBeingExecuted.set(references);
            }
            references.push(includedReference);
        }
        try {
            result = this.documentDisplayer.display((Object)documentBridge, (Object)displayParameters);
        }
        catch (Exception e) {
            throw new MacroExecutionException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (parametersContext == IncludeMacroParameters.Context.NEW) {
                references.pop();
            }
        }
        if (parameters.isExcludeFirstHeading()) {
            this.excludeFirstHeading(result);
        }
        MetaDataBlock metadata = new MetaDataBlock(result.getChildren(), result.getMetaData());
        String source = (String)this.defaultEntityReferenceSerializer.serialize(includedReference, new Object[0]);
        metadata.getMetaData().addMetaData("source", (Object)source);
        if (parametersContext == IncludeMacroParameters.Context.NEW) {
            metadata.getMetaData().addMetaData("base", (Object)source);
        }
        return Collections.singletonList(metadata);
    }

    protected void checkRecursion(Block currentBlock, EntityReference reference) throws MacroExecutionException {
        super.checkRecursion(reference, "inclusion");
        Block parentBlock = currentBlock.getParent();
        if (parentBlock != null) {
            MacroMarkerBlock parentMacro;
            if (parentBlock instanceof MacroMarkerBlock && this.isRecursive(parentMacro = (MacroMarkerBlock)parentBlock, reference)) {
                throw new MacroExecutionException("Found recursive inclusion of document [" + reference + "]");
            }
            this.checkRecursion(parentBlock, reference);
        }
    }

    private boolean isRecursive(MacroMarkerBlock parentMacro, EntityReference completeReference) {
        if (parentMacro.getId().equals("include")) {
            IncludeMacroParameters macroParameters = this.getParameters(parentMacro.getParameters());
            return completeReference.equals((Object)this.macroEntityReferenceResolver.resolve((Object)macroParameters.getReference(), macroParameters.getType(), new Object[]{parentMacro}));
        }
        return false;
    }

    private IncludeMacroParameters getParameters(Map<String, String> values) {
        IncludeMacroParameters parameters = new IncludeMacroParameters();
        try {
            this.beans.populate((Object)parameters, values);
        }
        catch (PropertyException propertyException) {
            // empty catch block
        }
        return parameters;
    }
}

