/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.rss;

import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.Reader;
import java.net.SocketTimeoutException;
import java.net.URLConnection;
import java.text.MessageFormat;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.rendering.internal.macro.rss.RomeFeedFactory;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.rss.RssMacroParameters;

public class DefaultRomeFeedFactory
implements RomeFeedFactory {
    private static final int TIMEOUT_MILLISECONDS = 5000;
    private static final String USER_AGENT_HEADER = "User-Agent";
    private static final String VERSION = DefaultRomeFeedFactory.class.getPackage().getImplementationVersion();
    private static final String USER_AGENT = "XWiki/" + VERSION;

    @Override
    public SyndFeed createFeed(RssMacroParameters parameters) throws MacroExecutionException {
        SyndFeed feed;
        if (StringUtils.isEmpty((CharSequence)parameters.getFeed())) {
            throw new MacroExecutionException("The required 'feed' parameter is missing");
        }
        SyndFeedInput syndFeedInput = new SyndFeedInput();
        try {
            if (StringUtils.startsWith((CharSequence)parameters.getFeed().toLowerCase(), (CharSequence)"https")) {
                HttpsURLConnection httpsURLConnection = (HttpsURLConnection)parameters.getFeedURL().openConnection();
                httpsURLConnection.setConnectTimeout(5000);
                httpsURLConnection.setRequestProperty(USER_AGENT_HEADER, USER_AGENT);
                feed = syndFeedInput.build((Reader)new XmlReader((URLConnection)httpsURLConnection));
            } else {
                URLConnection httpURLConnection = parameters.getFeedURL().openConnection();
                httpURLConnection.setConnectTimeout(5000);
                httpURLConnection.setRequestProperty(USER_AGENT_HEADER, USER_AGENT);
                feed = syndFeedInput.build((Reader)new XmlReader(httpURLConnection));
            }
        }
        catch (SocketTimeoutException ex) {
            throw new MacroExecutionException(MessageFormat.format("Connection timeout when trying to reach [{0}]", parameters.getFeedURL()));
        }
        catch (Exception ex) {
            throw new MacroExecutionException(MessageFormat.format("Error processing [{0}] : {1}", parameters.getFeedURL(), ex.getMessage()), (Throwable)ex);
        }
        if (feed == null) {
            throw new MacroExecutionException(MessageFormat.format("No feed found at [{0}]", parameters.getFeedURL()));
        }
        return feed;
    }
}

