/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.script;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.observation.event.CancelableEvent;
import org.xwiki.rendering.internal.macro.script.AbstractScriptCheckerListener;
import org.xwiki.rendering.macro.MacroId;
import org.xwiki.rendering.macro.MacroLookupException;
import org.xwiki.rendering.macro.MacroManager;
import org.xwiki.rendering.macro.script.MacroPermissionPolicy;
import org.xwiki.rendering.macro.script.PrivilegedScriptMacro;
import org.xwiki.rendering.macro.script.ScriptMacroParameters;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="permissionchecker")
@Singleton
public class PermissionCheckerListener
extends AbstractScriptCheckerListener {
    private static final String CANCEL_MESSAGE = "You don't have the right to execute this script";
    @Inject
    private MacroManager macroManager;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private ComponentManager componentManager;

    public String getName() {
        return "permissionchecker";
    }

    @Override
    protected void check(CancelableEvent event, MacroTransformationContext context, ScriptMacroParameters parameters) {
        MacroId currentMacroId = new MacroId(context.getCurrentMacroBlock().getId());
        try {
            MacroPermissionPolicy mpp = (MacroPermissionPolicy)this.componentManager.getInstance(MacroPermissionPolicy.class, currentMacroId.getId());
            if (!mpp.hasPermission(parameters, context)) {
                event.cancel(CANCEL_MESSAGE);
            }
        }
        catch (ComponentLookupException e) {
            this.backwardCompatibilityCheck(currentMacroId, event);
        }
    }

    private void backwardCompatibilityCheck(MacroId macroId, CancelableEvent event) {
        try {
            if (!(this.macroManager.getMacro(macroId) instanceof PrivilegedScriptMacro)) {
                return;
            }
            if (!this.documentAccessBridge.hasProgrammingRights()) {
                event.cancel(CANCEL_MESSAGE);
            }
        }
        catch (MacroLookupException macroLookupException) {
            // empty catch block
        }
    }
}

