/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.velocity;

import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.macro.script.AbstractScriptMacro;
import org.xwiki.rendering.macro.velocity.VelocityMacroConfiguration;
import org.xwiki.rendering.macro.velocity.VelocityMacroParameters;
import org.xwiki.rendering.macro.velocity.filter.VelocityMacroFilter;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.velocity.VelocityManager;
import org.xwiki.velocity.XWikiVelocityException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="velocity")
public class VelocityMacro
extends AbstractScriptMacro<VelocityMacroParameters> {
    private static final String DESCRIPTION = "Executes a Velocity script.";
    private static final String CONTENT_DESCRIPTION = "the velocity script to execute";
    @Requirement
    private VelocityManager velocityManager;
    @Requirement
    private VelocityMacroConfiguration configuration;

    public VelocityMacro() {
        super("Velocity", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION), VelocityMacroParameters.class);
    }

    public boolean supportsInlineMode() {
        return true;
    }

    protected String evaluateString(VelocityMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        String result = "";
        try {
            VelocityContext velocityContext = this.velocityManager.getVelocityContext();
            VelocityMacroFilter filter = this.getFilter(parameters);
            String cleanedContent = content;
            if (filter != null) {
                cleanedContent = filter.before(cleanedContent, velocityContext);
            }
            StringWriter writer = new StringWriter();
            String key = context.getTransformationContext().getId();
            if (key == null) {
                key = "unknown namespace";
            }
            this.velocityManager.getVelocityEngine().evaluate((Context)velocityContext, (Writer)writer, key, cleanedContent);
            result = writer.toString();
            if (filter != null) {
                result = filter.after(result, velocityContext);
            }
        }
        catch (XWikiVelocityException e) {
            throw new MacroExecutionException("Failed to evaluate Velocity Macro for content [" + content + "]", (Throwable)e);
        }
        return result;
    }

    private VelocityMacroFilter getFilter(VelocityMacroParameters parameters) {
        String filterName = parameters.getFilter();
        if (StringUtils.isEmpty((String)filterName) && StringUtils.isEmpty((String)(filterName = this.configuration.getFilter()))) {
            filterName = null;
        }
        VelocityMacroFilter filter = null;
        if (filterName != null) {
            try {
                filter = (VelocityMacroFilter)this.getComponentManager().lookup(VelocityMacroFilter.class, filterName);
            }
            catch (ComponentLookupException e) {
                this.getLogger().error("Can't find velocity maco cleaner", (Throwable)e);
            }
        }
        return filter;
    }
}

