/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.rendering.internal.macro.velocity.filter;

import java.util.regex.Pattern;

import org.apache.velocity.VelocityContext;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.macro.velocity.filter.VelocityMacroFilter;

/**
 * Remove first spaces and tabs of each line to support indentation.
 * 
 * @version $Id: 3adb495f3faadee6c9877af0024af52a45ddbc41 $
 * @since 1.9.1
 */
@Component("indent")
public class IndentVelocityMacroFilter implements VelocityMacroFilter
{
    /**
     * Match indentation spaces.
     */
    private static final Pattern INDENT_PATTERN = Pattern.compile("^[ \t]++", Pattern.MULTILINE);

    @Override
    public String before(String content, VelocityContext velocityContect)
    {
        return INDENT_PATTERN.matcher(content).replaceAll("");
    }

    @Override
    public String after(String content, VelocityContext velocityContect)
    {
        return content;
    }
}
