/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.signature.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.MacroMarkerBlock;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.MetadataBlockMatcher;
import org.xwiki.rendering.signature.internal.BlockDumper;

@Component
@Named(value="macro")
@Singleton
public class MacroBlockDumper
implements BlockDumper {
    @Override
    public void dump(OutputStream out, Block block) throws IOException {
        MacroBlock b;
        if (block instanceof MacroBlock) {
            b = (MacroBlock)block;
            MacroBlockDumper.dump(out, b.getId(), b.getParameters(), b.getContent());
        } else if (block instanceof MacroMarkerBlock) {
            b = (MacroMarkerBlock)block;
            MacroBlockDumper.dump(out, b.getId(), b.getParameters(), b.getContent());
        } else {
            throw new IllegalArgumentException("Unsupported block [" + block.getClass().getName() + "].");
        }
        String source = this.getSourceReference(block);
        if (source != null) {
            out.write(MacroBlockDumper.toBytes(source));
        }
        out.write(0);
    }

    @Override
    public byte[] dump(Block block) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.dump(out, block);
        return out.toByteArray();
    }

    private static void dump(OutputStream out, String macroId, Map<String, String> parameters, String content) throws IOException {
        out.write(MacroBlockDumper.toBytes(macroId));
        out.write(0);
        for (Map.Entry<String, String> param : parameters.entrySet()) {
            out.write(MacroBlockDumper.toBytes(param.getKey()));
            out.write(0);
            out.write(MacroBlockDumper.toBytes(param.getValue()));
            out.write(0);
        }
        out.write(0);
        if (content != null) {
            out.write(MacroBlockDumper.toBytes(content));
        }
        out.write(0);
    }

    private String getSourceReference(Block block) {
        MetaDataBlock metaDataBlock = (MetaDataBlock)block.getFirstBlock((BlockMatcher)new MetadataBlockMatcher("source"), Block.Axes.ANCESTOR);
        if (metaDataBlock != null) {
            return (String)metaDataBlock.getMetaData().getMetaData("source");
        }
        return null;
    }

    private static byte[] toBytes(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return s.getBytes();
        }
    }
}

