/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.signature.internal;

import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.pkix.CertificateProvider;
import org.xwiki.crypto.signer.CMSSignedDataVerifier;
import org.xwiki.crypto.signer.param.CMSSignedDataVerified;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.MacroMarkerBlock;
import org.xwiki.rendering.signature.BlockSignatureVerifier;
import org.xwiki.rendering.signature.internal.BlockDumper;

@Component
@Named(value="macro")
@Singleton
public class MacroBlockSignatureVerifier
implements BlockSignatureVerifier {
    @Inject
    @Named(value="macro")
    private BlockDumper dumper;
    @Inject
    private CMSSignedDataVerifier verifier;

    @Override
    public CMSSignedDataVerified verify(byte[] signature, Block block, CertificateProvider certificateProvider) throws GeneralSecurityException, IOException {
        if (!this.isSupported(block)) {
            throw new IllegalArgumentException("Unsupported block [" + block.getClass().getName() + "].");
        }
        return this.verifier.verify(signature, this.dumper.dump(block), certificateProvider);
    }

    @Override
    public boolean isSupported(Block block) {
        return block instanceof MacroBlock || block instanceof MacroMarkerBlock;
    }
}

