/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.macro.wikibridge;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.xwiki.rendering.macro.MacroId;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.MacroDescriptor;
import org.xwiki.rendering.macro.descriptor.ParameterDescriptor;
import org.xwiki.rendering.macro.wikibridge.WikiMacroParameterDescriptor;
import org.xwiki.rendering.macro.wikibridge.WikiMacroParameters;
import org.xwiki.rendering.macro.wikibridge.WikiMacroVisibility;

public class WikiMacroDescriptor
implements MacroDescriptor {
    private MacroId id;
    private String name;
    private String description;
    private String defaultCategory;
    private WikiMacroVisibility visibility;
    private boolean supportsInlineMode;
    private ContentDescriptor contentDescriptor;
    private List<WikiMacroParameterDescriptor> parameterDescriptors;

    private WikiMacroDescriptor() {
    }

    private WikiMacroDescriptor(WikiMacroDescriptor descriptor) {
        this.id = descriptor.id;
        this.name = descriptor.name;
        this.description = descriptor.description;
        this.contentDescriptor = descriptor.contentDescriptor;
        this.parameterDescriptors = descriptor.parameterDescriptors;
        this.defaultCategory = descriptor.defaultCategory;
        this.visibility = descriptor.visibility;
        this.supportsInlineMode = descriptor.supportsInlineMode;
    }

    @Deprecated
    public WikiMacroDescriptor(MacroId id, String name, String description, String defaultCategory, WikiMacroVisibility visibility, ContentDescriptor contentDescriptor, List<WikiMacroParameterDescriptor> parameterDescriptors) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.contentDescriptor = contentDescriptor;
        this.parameterDescriptors = parameterDescriptors;
        this.defaultCategory = defaultCategory;
        this.visibility = visibility;
    }

    @Deprecated
    public WikiMacroDescriptor(String name, String description, String defaultCategory, WikiMacroVisibility visibility, ContentDescriptor contentDescriptor, List<WikiMacroParameterDescriptor> parameterDescriptors) {
        this.name = name;
        this.description = description;
        this.contentDescriptor = contentDescriptor;
        this.parameterDescriptors = parameterDescriptors;
        this.defaultCategory = defaultCategory;
        this.visibility = visibility;
    }

    public MacroId getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ContentDescriptor getContentDescriptor() {
        return this.contentDescriptor;
    }

    public Class<?> getParametersBeanClass() {
        return WikiMacroParameters.class;
    }

    public Map<String, ParameterDescriptor> getParameterDescriptorMap() {
        LinkedHashMap<String, ParameterDescriptor> descriptors = new LinkedHashMap<String, ParameterDescriptor>();
        for (WikiMacroParameterDescriptor descriptor : this.parameterDescriptors) {
            descriptors.put(descriptor.getId().toLowerCase(), descriptor);
        }
        return descriptors;
    }

    public String getDefaultCategory() {
        return this.defaultCategory;
    }

    public WikiMacroVisibility getVisibility() {
        return this.visibility;
    }

    public boolean supportsInlineMode() {
        return this.supportsInlineMode;
    }

    public static class Builder {
        private final WikiMacroDescriptor descriptor = new WikiMacroDescriptor();

        public Builder id(MacroId id) {
            this.descriptor.id = id;
            return this;
        }

        public Builder name(String name) {
            this.descriptor.name = name;
            return this;
        }

        public Builder description(String description) {
            this.descriptor.description = description;
            return this;
        }

        public Builder defaultCategory(String defaultCategory) {
            this.descriptor.defaultCategory = defaultCategory;
            return this;
        }

        public Builder visibility(WikiMacroVisibility visibility) {
            this.descriptor.visibility = visibility;
            return this;
        }

        public Builder supportsInlineMode(boolean supportsInlineMode) {
            this.descriptor.supportsInlineMode = supportsInlineMode;
            return this;
        }

        public Builder contentDescriptor(ContentDescriptor contentDescriptor) {
            this.descriptor.contentDescriptor = contentDescriptor;
            return this;
        }

        public Builder parameterDescriptors(List<WikiMacroParameterDescriptor> parameterDescriptors) {
            this.descriptor.parameterDescriptors = parameterDescriptors;
            return this;
        }

        public WikiMacroDescriptor build() {
            return new WikiMacroDescriptor(this.descriptor);
        }
    }
}

