/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.wikibridge;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.event.ApplicationReadyEvent;
import org.xwiki.bridge.event.WikiReadyEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.rendering.macro.wikibridge.WikiMacroInitializer;

@Component
@Singleton
@Named(value="WikiMacroInitializerListener")
public class WikiMacroInitializerListener
implements EventListener {
    private static final List<Event> EVENTS = new ArrayList<Event>(Arrays.asList(new ApplicationReadyEvent(), new WikiReadyEvent()));
    @Inject
    private Provider<WikiMacroInitializer> macroInitializer;
    @Inject
    private Logger logger;

    public List<Event> getEvents() {
        return EVENTS;
    }

    public String getName() {
        return "WikiMacroInitializerListener";
    }

    public void onEvent(Event event, Object source, Object data) {
        WikiMacroInitializer initializer = (WikiMacroInitializer)this.macroInitializer.get();
        if (event instanceof ApplicationReadyEvent) {
            try {
                initializer.registerExistingWikiMacros();
            }
            catch (Exception e) {
                this.logger.error("Error while registering wiki macros.", (Throwable)e);
            }
        } else if (event instanceof WikiReadyEvent) {
            try {
                initializer.installOrUpgradeWikiMacroClasses();
            }
            catch (Exception e) {
                this.logger.error("Error while initializing wiki macro classes.", (Throwable)e);
            }
        }
    }
}

