/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.wikibridge;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.ModelContext;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.macro.Macro;
import org.xwiki.rendering.macro.wikibridge.InsufficientPrivilegesException;
import org.xwiki.rendering.macro.wikibridge.WikiMacro;
import org.xwiki.rendering.macro.wikibridge.WikiMacroDescriptor;
import org.xwiki.rendering.macro.wikibridge.WikiMacroException;
import org.xwiki.rendering.macro.wikibridge.WikiMacroFactory;
import org.xwiki.rendering.macro.wikibridge.WikiMacroManager;
import org.xwiki.rendering.macro.wikibridge.WikiMacroVisibility;

@Component
@Singleton
public class DefaultWikiMacroManager
implements WikiMacroManager {
    @Inject
    private ComponentManager rootComponentManager;
    @Inject
    private DocumentAccessBridge bridge;
    @Inject
    private ModelContext modelContext;
    @Inject
    private WikiMacroFactory wikiMacroFactory;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    private Map<DocumentReference, WikiMacroData> wikiMacroMap = new HashMap<DocumentReference, WikiMacroData>();

    @Override
    public boolean hasWikiMacro(DocumentReference documentReference) {
        return null != this.wikiMacroMap.get(documentReference);
    }

    @Override
    public void registerWikiMacro(DocumentReference documentReference, WikiMacro wikiMacro) throws InsufficientPrivilegesException, WikiMacroException {
        WikiMacroDescriptor macroDescriptor = (WikiMacroDescriptor)wikiMacro.getDescriptor();
        if (this.wikiMacroFactory.isAllowed(documentReference, macroDescriptor.getVisibility())) {
            DefaultComponentDescriptor componentDescriptor = new DefaultComponentDescriptor();
            componentDescriptor.setRoleType(Macro.class);
            componentDescriptor.setRoleHint(wikiMacro.getDescriptor().getId().getId());
            String currentUser = this.bridge.getCurrentUser();
            EntityReference currentEntityReference = this.modelContext.getCurrentEntityReference();
            try {
                this.bridge.setCurrentUser((String)this.serializer.serialize((EntityReference)(wikiMacro.getAuthorReference() != null ? wikiMacro.getAuthorReference() : this.bridge.getCurrentUserReference()), new Object[0]));
                this.modelContext.setCurrentEntityReference((EntityReference)documentReference);
                this.findComponentManager(macroDescriptor.getVisibility()).registerComponent((ComponentDescriptor)componentDescriptor, (Object)wikiMacro);
                this.wikiMacroMap.put(documentReference, new WikiMacroData(componentDescriptor.getRoleHint(), wikiMacro));
            }
            catch (Exception e) {
                throw new WikiMacroException(String.format("Failed to register macro [%s] in [%s] for visibility [%s]", new Object[]{wikiMacro.getDescriptor().getId().getId(), documentReference, macroDescriptor.getVisibility()}), e);
            }
            finally {
                this.bridge.setCurrentUser(currentUser);
                this.modelContext.setCurrentEntityReference(currentEntityReference);
            }
        } else {
            throw new InsufficientPrivilegesException(String.format("Unable to register macro [%s] in [%s] for visibility [%s] due to insufficient privileges", new Object[]{wikiMacro.getDescriptor().getId().getId(), documentReference, macroDescriptor.getVisibility()}));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void unregisterWikiMacro(DocumentReference documentReference) throws WikiMacroException {
        WikiMacroData macroData = this.wikiMacroMap.get(documentReference);
        if (macroData == null) throw new WikiMacroException(String.format("Macro in [%s] isn't registered", documentReference));
        WikiMacroDescriptor macroDescriptor = (WikiMacroDescriptor)macroData.getWikiMacro().getDescriptor();
        if (!this.wikiMacroFactory.isAllowed(documentReference, macroDescriptor.getVisibility())) throw new WikiMacroException(String.format("Unable to unregister macro [%s] in [%s] for visibility [%s] due to insufficient privileges", new Object[]{macroData.getWikiMacro().getDescriptor().getId().getId(), documentReference, macroDescriptor.getVisibility()}));
        String currentUser = this.bridge.getCurrentUser();
        EntityReference currentEntityReference = this.modelContext.getCurrentEntityReference();
        try {
            this.bridge.setCurrentUser((String)this.serializer.serialize((EntityReference)macroData.getWikiMacro().getAuthorReference(), new Object[0]));
            this.modelContext.setCurrentEntityReference((EntityReference)documentReference);
            this.findComponentManager(macroDescriptor.getVisibility()).unregisterComponent(Macro.class, macroData.getHint());
            this.wikiMacroMap.remove(documentReference);
            return;
        }
        catch (Exception e) {
            throw new WikiMacroException(String.format("Failed to unregister macro [%s] in [%s] for visibility [%s]", new Object[]{macroData.getHint(), documentReference, macroDescriptor.getVisibility()}), e);
        }
        finally {
            this.bridge.setCurrentUser(currentUser);
            this.modelContext.setCurrentEntityReference(currentEntityReference);
        }
    }

    private ComponentManager findComponentManager(WikiMacroVisibility visibility) throws ComponentLookupException {
        ComponentManager cm;
        switch (visibility) {
            case USER: {
                cm = (ComponentManager)this.rootComponentManager.getInstance(ComponentManager.class, "user");
                break;
            }
            case WIKI: {
                cm = (ComponentManager)this.rootComponentManager.getInstance(ComponentManager.class, "wiki");
                break;
            }
            default: {
                cm = this.rootComponentManager;
            }
        }
        return cm;
    }

    private static class WikiMacroData {
        private String hint;
        private WikiMacro wikiMacro;

        public WikiMacroData(String hint, WikiMacro wikiMacro) {
            this.hint = hint;
            this.wikiMacro = wikiMacro;
        }

        public String getHint() {
            return this.hint;
        }

        public WikiMacro getWikiMacro() {
            return this.wikiMacro;
        }
    }
}

