/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.resolver;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.rendering.listener.reference.ResourceReference;

@Component
@Singleton
public class DefaultResourceReferenceEntityReferenceResolver
implements EntityReferenceResolver<ResourceReference> {
    public static final ParameterizedType TYPE_RESOURCEREFERENCE = new DefaultParameterizedType(null, EntityReferenceResolver.class, new Type[]{ResourceReference.class});
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;

    public EntityReference resolve(ResourceReference resourceReference, EntityType type, Object ... parameters) {
        if (resourceReference == null) {
            return null;
        }
        if (((ComponentManager)this.componentManagerProvider.get()).hasComponent((Type)TYPE_RESOURCEREFERENCE, resourceReference.getType().getScheme())) {
            EntityReferenceResolver resolver;
            try {
                resolver = (EntityReferenceResolver)((ComponentManager)this.componentManagerProvider.get()).getInstance((Type)TYPE_RESOURCEREFERENCE, resourceReference.getType().getScheme());
            }
            catch (ComponentLookupException e) {
                throw new RuntimeException(String.format("Unknown error when trying to load resolver for reference [%s]", resourceReference), e);
            }
            return resolver.resolve((Object)resourceReference, type, parameters);
        }
        return null;
    }
}

