/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.resolver;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.AttachmentReferenceResolver;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.rendering.internal.resolver.AbstractResourceReferenceEntityReferenceResolver;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;

@Component
@Named(value="attach")
@Singleton
public class AttachmentResourceReferenceEntityReferenceResolver
extends AbstractResourceReferenceEntityReferenceResolver {
    @Inject
    private AttachmentReferenceResolver<EntityReference> defaultReferenceAttachmentReferenceResolver;
    @Inject
    private AttachmentReferenceResolver<String> defaultStringAttachmentReferenceResolver;
    @Inject
    @Named(value="relative")
    private EntityReferenceResolver<String> relativeReferenceResolver;

    public AttachmentResourceReferenceEntityReferenceResolver() {
        super(ResourceType.ATTACHMENT);
    }

    @Override
    protected EntityReference resolveTyped(ResourceReference resourceReference, EntityReference baseReference) {
        if (StringUtils.isEmpty((CharSequence)resourceReference.getReference())) {
            return this.defaultStringAttachmentReferenceResolver.resolve((Object)resourceReference.getReference(), new Object[]{baseReference});
        }
        EntityReference relativeReference = this.relativeReferenceResolver.resolve((Object)resourceReference.getReference(), EntityType.ATTACHMENT, new Object[0]);
        AttachmentReference attachmentReference = this.defaultReferenceAttachmentReferenceResolver.resolve((Object)relativeReference, new Object[]{baseReference});
        DocumentReference documentReference = attachmentReference.getDocumentReference();
        DocumentReference finalDocumentReference = this.resolveDocumentReference(relativeReference.getParent(), documentReference, baseReference);
        if (finalDocumentReference != documentReference) {
            attachmentReference = new AttachmentReference(attachmentReference.getName(), finalDocumentReference);
        }
        return attachmentReference;
    }
}

