/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.rendering.configuration.RenderingConfiguration;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.renderer.reference.link.LinkLabelGenerator;

@Component
@Singleton
public class XWikiLinkLabelGenerator
implements LinkLabelGenerator {
    @Inject
    private RenderingConfiguration renderingConfiguration;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private EntityReferenceResolver<ResourceReference> resourceReferenceResolver;

    public String generate(ResourceReference reference) {
        String format = this.renderingConfiguration.getLinkLabelFormat();
        EntityReference resolvedReference = this.resourceReferenceResolver.resolve((Object)reference, EntityType.DOCUMENT, new Object[0]);
        if (resolvedReference == null) {
            throw new IllegalArgumentException(String.valueOf(reference));
        }
        DocumentReference documentReference = new DocumentReference(resolvedReference);
        String result = format.replace("%w", documentReference.getWikiReference().getName());
        result = result.replace("%p", documentReference.getName());
        if ((result = result.replace("%s", documentReference.getLastSpaceReference().getName())).indexOf("%P") > -1) {
            String normalizedPage = documentReference.getName().replaceAll("([a-z])([A-Z])", "$1 $2");
            result = result.replace("%P", normalizedPage);
        }
        if (result.indexOf("%t") > -1) {
            try {
                DocumentModelBridge document = this.documentAccessBridge.getDocument(documentReference);
                result = StringUtils.isNotBlank((CharSequence)document.getTitle()) ? result.replace("%t", document.getTitle()) : documentReference.getName();
            }
            catch (Exception e) {
                result = documentReference.getName();
            }
        }
        return result;
    }
}

