/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.parser;

import java.io.Reader;
import java.io.StringReader;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.internal.parser.MissingParserException;
import org.xwiki.rendering.parser.ContentParser;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.syntax.Syntax;

@Component
@Singleton
public class DefaultContentParser
implements ContentParser {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private EntityReferenceSerializer<String> serializer;

    @Override
    public XDOM parse(String content, Syntax syntax) throws ParseException, MissingParserException {
        return this.getParser(syntax).parse((Reader)new StringReader(content));
    }

    @Override
    public XDOM parse(String content, Syntax syntax, EntityReference source) throws ParseException, MissingParserException {
        XDOM xdom = this.parse(content, syntax);
        if (source != null) {
            xdom.getMetaData().addMetaData("source", this.serializer.serialize(source, new Object[0]));
        }
        return xdom;
    }

    private Parser getParser(Syntax syntax) throws MissingParserException {
        try {
            return (Parser)((ComponentManager)this.componentManagerProvider.get()).getInstance(Parser.class, syntax.toIdString());
        }
        catch (ComponentLookupException e) {
            throw new MissingParserException(syntax, (Throwable)e);
        }
    }
}

