/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.resource;

import org.xwiki.stability.Unstable;

/**
 * Helper to implement Resource Handlers, providing some default implementation. We recommend Handler writers to extend
 * this class.
 *
 * @param <T> the type of supported items
 * @version $Id: 069acf442369d7d70b80c4ded156a0a1f728527b $
 * @since 6.1M2
 */
@Unstable
public abstract class AbstractResourceReferenceHandler<T> implements ResourceReferenceHandler<T>
{
    /**
     * @see ResourceReferenceHandler#getPriority()
     */
    private int priority = 1000;

    @Override
    public int getPriority()
    {
        return this.priority;
    }

    /**
     * @param priority the Handler priority to use (lower means execute before others), see {@link #getPriority()}
     */
    public void setPriority(int priority)
    {
        this.priority = priority;
    }

    @Override
    public int compareTo(ResourceReferenceHandler handler)
    {
        return getPriority() - handler.getPriority();
    }
}
