/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.resource.internal.entity;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.environment.Environment;
import org.xwiki.resource.ResourceReferenceHandler;
import org.xwiki.resource.entity.EntityResourceAction;
import org.xwiki.resource.internal.entity.EntityResourceActionLister;

@Component
@Singleton
public class DefaultEntityResourceActionLister
implements EntityResourceActionLister,
Initializable {
    private static final String STRUTS_CONFIG_RESOURCE = "/WEB-INF/struts-config.xml";
    private List<String> strutsActionNames;
    @Inject
    private Environment environment;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> contextComponentManagerProvider;

    protected SAXBuilder createSAXBuilder() {
        SAXBuilder builder = new SAXBuilder();
        builder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new StringReader(""));
            }
        });
        return builder;
    }

    public void initialize() throws InitializationException {
        ArrayList<String> actionNames = new ArrayList<String>();
        InputStream strutsConfigStream = this.environment.getResourceAsStream(this.getStrutsConfigResource());
        if (strutsConfigStream != null) {
            Document document;
            try {
                document = this.createSAXBuilder().build(strutsConfigStream);
            }
            catch (IOException | JDOMException e) {
                throw new InitializationException(String.format("Failed to parse Struts Config file [%s]", this.getStrutsConfigResource()), e);
            }
            Element mappingElement = document.getRootElement().getChild("action-mappings");
            for (Element element : mappingElement.getChildren("action")) {
                actionNames.add(StringUtils.strip((String)element.getAttributeValue("path"), (String)"/"));
            }
        }
        this.strutsActionNames = actionNames;
    }

    @Override
    public List<String> listActions() {
        ArrayList<String> actionNames = new ArrayList<String>(this.strutsActionNames);
        try {
            Map componentMap = ((ComponentManager)this.contextComponentManagerProvider.get()).getInstanceMap((Type)new DefaultParameterizedType(null, ResourceReferenceHandler.class, new Type[]{EntityResourceAction.class}));
            for (String key : componentMap.keySet()) {
                actionNames.add(key);
            }
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Failed to locate Resource Reference Handlers", e);
        }
        return actionNames;
    }

    protected String getStrutsConfigResource() {
        return STRUTS_CONFIG_RESOURCE;
    }
}

