/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.resource.internal;

import java.lang.reflect.Type;
import java.util.List;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.resource.NotFoundResourceHandlerException;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceHandler;
import org.xwiki.resource.ResourceReferenceHandlerException;
import org.xwiki.resource.ResourceReferenceHandlerManager;
import org.xwiki.resource.internal.DefaultResourceReferenceHandlerChain;

public abstract class AbstractResourceReferenceHandlerManager
implements ResourceReferenceHandlerManager {
    @Inject
    @Named(value="context")
    private ComponentManager contextComponentManager;

    protected abstract boolean matches(ResourceReferenceHandler var1, ResourceReference var2);

    protected void handle(ResourceReference reference, Class typeClass) throws ResourceReferenceHandlerException {
        TreeSet<ResourceReferenceHandler> orderedHandlers = new TreeSet<ResourceReferenceHandler>();
        for (ResourceReferenceHandler handler : this.getHandlers(typeClass)) {
            if (!this.matches(handler, reference)) continue;
            orderedHandlers.add(handler);
        }
        if (orderedHandlers.isEmpty()) {
            throw new NotFoundResourceHandlerException(reference);
        }
        DefaultResourceReferenceHandlerChain chain = new DefaultResourceReferenceHandlerChain(orderedHandlers);
        chain.handleNext(reference);
    }

    private List<ResourceReferenceHandler> getHandlers(Class typeClass) throws ResourceReferenceHandlerException {
        try {
            return this.contextComponentManager.getInstanceList((Type)new DefaultParameterizedType(null, ResourceReferenceHandler.class, new Type[]{typeClass}));
        }
        catch (ComponentLookupException e) {
            throw new ResourceReferenceHandlerException("Failed to locate Resource Reference Handler components", (Throwable)e);
        }
    }
}

