/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.resource.internal;

import java.util.Collection;
import java.util.Stack;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceHandler;
import org.xwiki.resource.ResourceReferenceHandlerChain;
import org.xwiki.resource.ResourceReferenceHandlerException;

@Component
@Singleton
public class DefaultResourceReferenceHandlerChain
implements ResourceReferenceHandlerChain {
    private Stack<ResourceReferenceHandler> handlerStack = new Stack();

    public DefaultResourceReferenceHandlerChain(Collection<ResourceReferenceHandler> orderedHandlers) {
        this.handlerStack.addAll(orderedHandlers);
    }

    public void handleNext(ResourceReference reference) throws ResourceReferenceHandlerException {
        if (!this.handlerStack.isEmpty()) {
            this.handlerStack.pop().handle(reference, (ResourceReferenceHandlerChain)this);
        }
    }
}

