/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.resource.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceHandler;
import org.xwiki.resource.ResourceReferenceHandlerChain;
import org.xwiki.resource.ResourceReferenceHandlerException;
import org.xwiki.resource.events.ResourceReferenceHandledEvent;
import org.xwiki.resource.events.ResourceReferenceHandlingEvent;

public class DefaultResourceReferenceHandlerChain
implements ResourceReferenceHandlerChain {
    public static final DefaultResourceReferenceHandlerChain EMPTY = new DefaultResourceReferenceHandlerChain(Collections.emptyList(), null);
    private final Queue<ResourceReferenceHandler> handlerStack;
    private final ObservationManager observation;

    public DefaultResourceReferenceHandlerChain(Collection<ResourceReferenceHandler> orderedHandlers, ObservationManager observation) {
        this.handlerStack = new LinkedList<ResourceReferenceHandler>(orderedHandlers);
        this.observation = observation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNext(ResourceReference reference) throws ResourceReferenceHandlerException {
        if (!this.handlerStack.isEmpty()) {
            ResourceReferenceHandler handler = this.handlerStack.poll();
            if (this.observation != null) {
                this.observation.notify((Event)new ResourceReferenceHandlingEvent(reference), (Object)handler);
            }
            ResourceReferenceHandlerException exception = null;
            try {
                handler.handle(reference, (ResourceReferenceHandlerChain)this);
            }
            catch (ResourceReferenceHandlerException e) {
                exception = e;
            }
            finally {
                if (this.observation != null) {
                    this.observation.notify((Event)new ResourceReferenceHandledEvent(reference), (Object)handler, (Object)exception);
                }
            }
        }
    }
}

