/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Attachment;
import com.xpn.xwiki.api.Class;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.Element;
import com.xpn.xwiki.api.Object;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseObjectReference;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.PropertyInterface;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.ComputedFieldClass;
import com.xpn.xwiki.objects.classes.ListClass;
import com.xpn.xwiki.objects.classes.PropertyClass;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.DefaultRequest;
import org.xwiki.job.Request;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.tail.LogTail;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.JAXBConverter;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Attribute;
import org.xwiki.rest.model.jaxb.Hierarchy;
import org.xwiki.rest.model.jaxb.HierarchyItem;
import org.xwiki.rest.model.jaxb.JobId;
import org.xwiki.rest.model.jaxb.JobLog;
import org.xwiki.rest.model.jaxb.JobProgress;
import org.xwiki.rest.model.jaxb.JobRequest;
import org.xwiki.rest.model.jaxb.JobStatus;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.LogEvent;
import org.xwiki.rest.model.jaxb.MapEntry;
import org.xwiki.rest.model.jaxb.ObjectFactory;
import org.xwiki.rest.model.jaxb.ObjectSummary;
import org.xwiki.rest.model.jaxb.Page;
import org.xwiki.rest.model.jaxb.PageSummary;
import org.xwiki.rest.model.jaxb.Property;
import org.xwiki.rest.model.jaxb.Space;
import org.xwiki.rest.model.jaxb.Translation;
import org.xwiki.rest.model.jaxb.Translations;
import org.xwiki.rest.model.jaxb.Wiki;
import org.xwiki.rest.resources.ModificationsResource;
import org.xwiki.rest.resources.SyntaxesResource;
import org.xwiki.rest.resources.attachments.AttachmentMetadataResource;
import org.xwiki.rest.resources.attachments.AttachmentResource;
import org.xwiki.rest.resources.attachments.AttachmentVersionResource;
import org.xwiki.rest.resources.attachments.AttachmentsAtPageVersionResource;
import org.xwiki.rest.resources.attachments.AttachmentsResource;
import org.xwiki.rest.resources.classes.ClassPropertiesResource;
import org.xwiki.rest.resources.classes.ClassPropertyResource;
import org.xwiki.rest.resources.classes.ClassResource;
import org.xwiki.rest.resources.classes.ClassesResource;
import org.xwiki.rest.resources.comments.CommentsResource;
import org.xwiki.rest.resources.comments.CommentsVersionResource;
import org.xwiki.rest.resources.objects.AllObjectsForClassNameResource;
import org.xwiki.rest.resources.objects.ObjectAtPageVersionResource;
import org.xwiki.rest.resources.objects.ObjectPropertiesAtPageVersionResource;
import org.xwiki.rest.resources.objects.ObjectPropertiesResource;
import org.xwiki.rest.resources.objects.ObjectPropertyAtPageVersionResource;
import org.xwiki.rest.resources.objects.ObjectPropertyResource;
import org.xwiki.rest.resources.objects.ObjectResource;
import org.xwiki.rest.resources.objects.ObjectsAtPageVersionResource;
import org.xwiki.rest.resources.objects.ObjectsResource;
import org.xwiki.rest.resources.pages.PageChildrenResource;
import org.xwiki.rest.resources.pages.PageHistoryResource;
import org.xwiki.rest.resources.pages.PageResource;
import org.xwiki.rest.resources.pages.PageTagsResource;
import org.xwiki.rest.resources.pages.PageTranslationHistoryResource;
import org.xwiki.rest.resources.pages.PageTranslationResource;
import org.xwiki.rest.resources.pages.PagesResource;
import org.xwiki.rest.resources.spaces.SpaceResource;
import org.xwiki.rest.resources.spaces.SpaceSearchResource;
import org.xwiki.rest.resources.spaces.SpacesResource;
import org.xwiki.rest.resources.wikis.WikiSearchQueryResource;
import org.xwiki.rest.resources.wikis.WikiSearchResource;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.wiki.descriptor.WikiDescriptor;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component(roles={ModelFactory.class})
@Singleton
public class ModelFactory {
    private static final String PASSWORD_TYPE = "Password";
    private final ObjectFactory objectFactory = new ObjectFactory();
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private JAXBConverter jaxbConverter;
    @Inject
    private Provider<ContextualAuthorizationManager> authorizationManagerProvider;
    @Inject
    private Logger logger;
    @Inject
    private EntityReferenceSerializer<String> defaultEntityReferenceSerializer;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;

    public boolean toDocument(Document doc, Page restPage) throws XWikiException {
        boolean modified = false;
        if (restPage.getContent() != null) {
            doc.setContent(restPage.getContent());
            modified = true;
        }
        if (restPage.getTitle() != null) {
            doc.setTitle(restPage.getTitle());
            modified = true;
        }
        if (restPage.getParent() != null) {
            doc.setParent(restPage.getParent());
            modified = true;
        }
        if (restPage.getSyntax() != null) {
            doc.setSyntaxId(restPage.getSyntax());
            modified = true;
        }
        doc.setHidden(restPage.isHidden());
        if (restPage.getObjects() != null) {
            HashSet<BaseObjectReference> newReferences = new HashSet<BaseObjectReference>();
            for (ObjectSummary restObjectSummary : restPage.getObjects().getObjectSummaries()) {
                if (restObjectSummary == null) continue;
                org.xwiki.rest.model.jaxb.Object restObject = (org.xwiki.rest.model.jaxb.Object)restObjectSummary;
                Object xwikiObject = doc.getObject(restObject.getClassName(), restObject.getNumber());
                if (xwikiObject == null) {
                    xwikiObject = doc.newObject(restObject.getClassName());
                }
                this.toObject(xwikiObject, restObject);
                modified = true;
                newReferences.add(xwikiObject.getReference());
            }
            ArrayList<Object> toRemove = new ArrayList<Object>();
            for (Vector objects : doc.getxWikiObjects().values()) {
                for (Object object : objects) {
                    if (newReferences.contains(object.getReference())) continue;
                    toRemove.add(object);
                }
            }
            for (Object obj : toRemove) {
                doc.removeObject(obj);
                modified = true;
            }
        }
        return modified;
    }

    private void fillObjectSummary(ObjectSummary objectSummary, Document doc, BaseObject xwikiObject, Boolean withPrettyNames) {
        objectSummary.setId(String.format("%s:%s", doc.getPrefixedFullName(), xwikiObject.getGuid()));
        objectSummary.setGuid(xwikiObject.getGuid());
        objectSummary.setPageId(doc.getPrefixedFullName());
        objectSummary.setPageVersion(doc.getVersion());
        objectSummary.setPageAuthor(doc.getAuthor());
        if (withPrettyNames.booleanValue()) {
            XWikiContext xwikiContext = (XWikiContext)this.xcontextProvider.get();
            objectSummary.setPageAuthorName(xwikiContext.getWiki().getUserName(doc.getAuthor(), null, false, xwikiContext));
        }
        objectSummary.setWiki(doc.getWiki());
        objectSummary.setSpace(doc.getSpace());
        objectSummary.setPageName(doc.getDocumentReference().getName());
        objectSummary.setClassName(xwikiObject.getClassName());
        objectSummary.setNumber(xwikiObject.getNumber());
        String[] propertyNames = xwikiObject.getPropertyNames();
        if (propertyNames.length > 0) {
            try {
                objectSummary.setHeadline(ModelFactory.serializePropertyValue(xwikiObject.get(propertyNames[0])));
            }
            catch (XWikiException xWikiException) {
                // empty catch block
            }
        }
    }

    public ObjectSummary toRestObjectSummary(URI baseUri, Document doc, BaseObject xwikiObject, boolean useVersion, Boolean withPrettyNames) {
        ObjectSummary objectSummary = this.objectFactory.createObjectSummary();
        this.fillObjectSummary(objectSummary, doc, xwikiObject, withPrettyNames);
        Link objectLink = ModelFactory.getObjectLink(this.objectFactory, baseUri, doc, xwikiObject, useVersion, "http://www.xwiki.org/rel/object");
        objectSummary.getLinks().add(objectLink);
        String propertiesUri = useVersion ? Utils.createURI(baseUri, ObjectPropertiesAtPageVersionResource.class, doc.getWiki(), Utils.getSpacesFromSpaceId(doc.getSpace()), doc.getDocumentReference().getName(), doc.getVersion(), xwikiObject.getClassName(), xwikiObject.getNumber()).toString() : Utils.createURI(baseUri, ObjectPropertiesResource.class, doc.getWiki(), Utils.getSpacesFromSpaceId(doc.getSpace()), doc.getDocumentReference().getName(), xwikiObject.getClassName(), xwikiObject.getNumber()).toString();
        Link propertyLink = this.objectFactory.createLink();
        propertyLink.setHref(propertiesUri);
        propertyLink.setRel("http://www.xwiki.org/rel/properties");
        objectSummary.getLinks().add(propertyLink);
        return objectSummary;
    }

    public void toObject(Object xwikiObject, org.xwiki.rest.model.jaxb.Object restObject) {
        for (Property restProperty : restObject.getProperties()) {
            xwikiObject.set(restProperty.getName(), (java.lang.Object)restProperty.getValue());
        }
    }

    public org.xwiki.rest.model.jaxb.Object toRestObject(URI baseUri, Document doc, BaseObject xwikiObject, boolean useVersion, Boolean withPrettyNames) {
        org.xwiki.rest.model.jaxb.Object object = this.objectFactory.createObject();
        this.fillObjectSummary((ObjectSummary)object, doc, xwikiObject, withPrettyNames);
        XWikiContext xwikiContext = (XWikiContext)this.xcontextProvider.get();
        BaseClass xwikiClass = xwikiObject.getXClass(xwikiContext);
        for (java.lang.Object propertyClassObject : xwikiClass.getProperties()) {
            ListClass listClass;
            List allowedValueList;
            PropertyClass propertyClass = (PropertyClass)propertyClassObject;
            Property property = this.objectFactory.createProperty();
            for (java.lang.Object o : propertyClass.getProperties()) {
                BaseProperty baseProperty = (BaseProperty)o;
                Attribute attribute = this.objectFactory.createAttribute();
                attribute.setName(baseProperty.getName());
                if (baseProperty.getValue() != null) {
                    attribute.setValue(baseProperty.getValue().toString());
                } else {
                    attribute.setValue("");
                }
                property.getAttributes().add(attribute);
            }
            if (propertyClass instanceof ListClass && !(allowedValueList = (listClass = (ListClass)propertyClass).getList(xwikiContext)).isEmpty()) {
                Formatter f = new Formatter();
                for (int i = 0; i < allowedValueList.size(); ++i) {
                    if (i != allowedValueList.size() - 1) {
                        f.format("%s,", allowedValueList.get(i).toString());
                        continue;
                    }
                    f.format("%s", allowedValueList.get(i).toString());
                }
                Attribute attribute = this.objectFactory.createAttribute();
                attribute.setName("allowedValues");
                attribute.setValue(f.toString());
                property.getAttributes().add(attribute);
            }
            property.setName(propertyClass.getName());
            property.setType(propertyClass.getClassType());
            if (this.hasAccess(property)) {
                try {
                    property.setValue(this.serializePropertyValue(xwikiObject.get(propertyClass.getName()), propertyClass, xwikiContext));
                }
                catch (XWikiException e) {
                    this.logger.error("Unexpected exception when accessing property [{}]", (java.lang.Object)propertyClass.getName(), (java.lang.Object)e);
                }
            }
            String propertyUri = useVersion ? Utils.createURI(baseUri, ObjectPropertyAtPageVersionResource.class, doc.getWiki(), Utils.getSpacesFromSpaceId(doc.getSpace()), doc.getDocumentReference().getName(), doc.getVersion(), xwikiObject.getClassName(), xwikiObject.getNumber(), propertyClass.getName()).toString() : Utils.createURI(baseUri, ObjectPropertyResource.class, doc.getWiki(), Utils.getSpacesFromSpaceId(doc.getSpace()), doc.getDocumentReference().getName(), xwikiObject.getClassName(), xwikiObject.getNumber(), propertyClass.getName()).toString();
            Link propertyLink = this.objectFactory.createLink();
            propertyLink.setHref(propertyUri);
            propertyLink.setRel("self");
            property.getLinks().add(propertyLink);
            object.getProperties().add(property);
        }
        Link objectLink = ModelFactory.getObjectLink(this.objectFactory, baseUri, doc, xwikiObject, useVersion, "self");
        object.getLinks().add(objectLink);
        return object;
    }

    private static Link getObjectLink(ObjectFactory objectFactory, URI baseUri, Document doc, BaseObject xwikiObject, boolean useVersion, String relation) {
        String objectUri = useVersion ? Utils.createURI(baseUri, ObjectAtPageVersionResource.class, doc.getWiki(), Utils.getSpacesFromSpaceId(doc.getSpace()), doc.getDocumentReference().getName(), doc.getVersion(), xwikiObject.getClassName(), xwikiObject.getNumber()).toString() : Utils.createURI(baseUri, ObjectResource.class, doc.getWiki(), Utils.getSpacesFromSpaceId(doc.getSpace()), doc.getDocumentReference().getName(), xwikiObject.getClassName(), xwikiObject.getNumber()).toString();
        Link objectLink = objectFactory.createLink();
        objectLink.setHref(objectUri);
        objectLink.setRel(relation);
        return objectLink;
    }

    public Wiki toRestWiki(URI baseUri, String wikiName) {
        Wiki wiki = this.objectFactory.createWiki().withId(wikiName).withName(wikiName);
        String spacesUri = Utils.createURI(baseUri, SpacesResource.class, wikiName).toString();
        Link spacesLink = this.objectFactory.createLink();
        spacesLink.setHref(spacesUri);
        spacesLink.setRel("http://www.xwiki.org/rel/spaces");
        wiki.getLinks().add(spacesLink);
        String classesUri = Utils.createURI(baseUri, ClassesResource.class, wikiName).toString();
        Link classesLink = this.objectFactory.createLink();
        classesLink.setHref(classesUri);
        classesLink.setRel("http://www.xwiki.org/rel/classes");
        wiki.getLinks().add(classesLink);
        String modificationsUri = Utils.createURI(baseUri, ModificationsResource.class, wikiName).toString();
        Link modificationsLink = this.objectFactory.createLink();
        modificationsLink.setHref(modificationsUri);
        modificationsLink.setRel("http://www.xwiki.org/rel/modifications");
        wiki.getLinks().add(modificationsLink);
        String searchUri = Utils.createURI(baseUri, WikiSearchResource.class, wikiName).toString();
        Link searchLink = this.objectFactory.createLink();
        searchLink.setHref(searchUri);
        searchLink.setRel("http://www.xwiki.org/rel/search");
        wiki.getLinks().add(searchLink);
        String queryUri = Utils.createURI(baseUri, WikiSearchQueryResource.class, wikiName).toString();
        Link queryLink = this.objectFactory.createLink();
        queryLink.setHref(queryUri);
        queryLink.setRel("http://www.xwiki.org/rel/query");
        wiki.getLinks().add(queryLink);
        return wiki;
    }

    public Space toRestSpace(URI baseUri, String wikiName, List<String> spaces, Document home) {
        Space space = this.objectFactory.createSpace();
        space.setId(Utils.getSpaceId(wikiName, spaces));
        space.setWiki(wikiName);
        space.setName(spaces.get(spaces.size() - 1));
        if (home != null) {
            space.setHome(home.getPrefixedFullName());
            space.setXwikiRelativeUrl(home.getURL("view"));
            space.setXwikiAbsoluteUrl(home.getExternalURL("view"));
        }
        String pagesUri = Utils.createURI(baseUri, PagesResource.class, wikiName, spaces).toString();
        Link pagesLink = this.objectFactory.createLink();
        pagesLink.setHref(pagesUri);
        pagesLink.setRel("http://www.xwiki.org/rel/pages");
        space.getLinks().add(pagesLink);
        if (home != null) {
            String homeUri = Utils.createURI(baseUri, PageResource.class, wikiName, spaces, home.getDocumentReference().getName()).toString();
            Link homeLink = this.objectFactory.createLink();
            homeLink.setHref(homeUri);
            homeLink.setRel("http://www.xwiki.org/rel/home");
            space.getLinks().add(homeLink);
        }
        String searchUri = Utils.createURI(baseUri, SpaceSearchResource.class, wikiName, spaces).toString();
        Link searchLink = this.objectFactory.createLink();
        searchLink.setHref(searchUri);
        searchLink.setRel("http://www.xwiki.org/rel/search");
        space.getLinks().add(searchLink);
        return space;
    }

    public Translations toRestTranslations(URI baseUri, Document doc) throws XWikiException {
        Translations translations = this.objectFactory.createTranslations();
        translations.setDefault(doc.getDefaultLocale().toString());
        List languages = doc.getTranslationList();
        List<String> spaces = Utils.getSpacesFromSpaceId(doc.getSpace());
        if (!languages.isEmpty() && !Locale.ROOT.equals(doc.getDefaultLocale())) {
            Translation translation = this.objectFactory.createTranslation();
            translation.setLanguage(doc.getDefaultLocale().toString());
            String pageTranslationUri = Utils.createURI(baseUri, PageResource.class, doc.getWiki(), spaces, doc.getDocumentReference().getName()).toString();
            Link pageTranslationLink = this.objectFactory.createLink();
            pageTranslationLink.setHref(pageTranslationUri);
            pageTranslationLink.setRel("http://www.xwiki.org/rel/page");
            translation.getLinks().add(pageTranslationLink);
            String historyUri = Utils.createURI(baseUri, PageHistoryResource.class, doc.getWiki(), spaces, doc.getDocumentReference().getName()).toString();
            Link historyLink = this.objectFactory.createLink();
            historyLink.setHref(historyUri);
            historyLink.setRel("http://www.xwiki.org/rel/history");
            translation.getLinks().add(historyLink);
            translations.getTranslations().add(translation);
        }
        for (String language : languages) {
            Translation translation = this.objectFactory.createTranslation();
            translation.setLanguage(language);
            String pageTranslationUri = Utils.createURI(baseUri, PageTranslationResource.class, doc.getWiki(), spaces, doc.getDocumentReference().getName(), language).toString();
            Link pageTranslationLink = this.objectFactory.createLink();
            pageTranslationLink.setHref(pageTranslationUri);
            pageTranslationLink.setRel("http://www.xwiki.org/rel/page");
            translation.getLinks().add(pageTranslationLink);
            String historyUri = Utils.createURI(baseUri, PageTranslationHistoryResource.class, doc.getWiki(), spaces, doc.getDocumentReference().getName(), language).toString();
            Link historyLink = this.objectFactory.createLink();
            historyLink.setHref(historyUri);
            historyLink.setRel("http://www.xwiki.org/rel/history");
            translation.getLinks().add(historyLink);
            translations.getTranslations().add(translation);
        }
        return translations;
    }

    private void toRestPageSummary(PageSummary pageSummary, URI baseUri, Document doc, boolean useVersion, Boolean withPrettyNames) throws XWikiException {
        Object tagsObject;
        boolean parentExist;
        XWikiContext xwikiContext = (XWikiContext)this.xcontextProvider.get();
        pageSummary.setWiki(doc.getWiki());
        pageSummary.setFullName(doc.getFullName());
        pageSummary.setId(doc.getPrefixedFullName());
        pageSummary.setSpace(doc.getSpace());
        pageSummary.setName(doc.getDocumentReference().getName());
        pageSummary.setTitle(doc.getDisplayTitle());
        pageSummary.setXwikiRelativeUrl(doc.getURL("view"));
        pageSummary.setXwikiAbsoluteUrl(doc.getExternalURL("view"));
        pageSummary.setTranslations(this.toRestTranslations(baseUri, doc));
        pageSummary.setSyntax(doc.getSyntax().toIdString());
        pageSummary.setVersion(doc.getVersion());
        pageSummary.setAuthor(doc.getAuthor());
        if (withPrettyNames.booleanValue()) {
            pageSummary.setAuthorName(xwikiContext.getWiki().getUserName(doc.getAuthor(), null, false, xwikiContext));
        }
        pageSummary.setParent(doc.getParent());
        DocumentReference parentReference = doc.getParentReference();
        boolean bl = parentExist = parentReference != null && xwikiContext.getWiki().exists(parentReference, xwikiContext);
        if (parentExist) {
            pageSummary.setParentId((String)this.serializer.serialize((EntityReference)parentReference, new java.lang.Object[0]));
        } else {
            pageSummary.setParentId("");
        }
        List<String> spaces = Utils.getSpacesFromSpaceId(doc.getSpace());
        String spaceUri = Utils.createURI(baseUri, SpaceResource.class, doc.getWiki(), spaces).toString();
        Link spaceLink = this.objectFactory.createLink();
        spaceLink.setHref(spaceUri);
        spaceLink.setRel("http://www.xwiki.org/rel/space");
        pageSummary.getLinks().add(spaceLink);
        if (parentExist) {
            String parentUri = Utils.createURI(baseUri, PageResource.class, parentReference.getWikiReference().getName(), spaces, parentReference.getName()).toString();
            Link parentLink = this.objectFactory.createLink();
            parentLink.setHref(parentUri);
            parentLink.setRel("http://www.xwiki.org/rel/parent");
            pageSummary.getLinks().add(parentLink);
        }
        String historyUri = Utils.createURI(baseUri, PageHistoryResource.class, doc.getWiki(), Utils.getSpacesFromSpaceId(doc.getSpace()), doc.getDocumentReference().getName()).toString();
        Link historyLink = this.objectFactory.createLink();
        historyLink.setHref(historyUri);
        historyLink.setRel("http://www.xwiki.org/rel/history");
        pageSummary.getLinks().add(historyLink);
        if (!doc.getChildren().isEmpty()) {
            String pageChildrenUri = Utils.createURI(baseUri, PageChildrenResource.class, doc.getWiki(), spaces, doc.getDocumentReference().getName()).toString();
            Link pageChildrenLink = this.objectFactory.createLink();
            pageChildrenLink.setHref(pageChildrenUri);
            pageChildrenLink.setRel("http://www.xwiki.org/rel/children");
            pageSummary.getLinks().add(pageChildrenLink);
        }
        if (!doc.getComments().isEmpty()) {
            String commentsUri = useVersion ? Utils.createURI(baseUri, CommentsVersionResource.class, doc.getWiki(), spaces, doc.getDocumentReference().getName(), doc.getVersion()).toString() : Utils.createURI(baseUri, CommentsResource.class, doc.getWiki(), spaces, doc.getDocumentReference().getName()).toString();
            Link commentsLink = this.objectFactory.createLink();
            commentsLink.setHref(commentsUri);
            commentsLink.setRel("http://www.xwiki.org/rel/comments");
            pageSummary.getLinks().add(commentsLink);
        }
        if (!doc.getAttachmentList().isEmpty()) {
            String attachmentsUri = useVersion ? Utils.createURI(baseUri, AttachmentsAtPageVersionResource.class, doc.getWiki(), spaces, doc.getDocumentReference().getName(), doc.getVersion()).toString() : Utils.createURI(baseUri, AttachmentsResource.class, doc.getWiki(), spaces, doc.getDocumentReference().getName()).toString();
            Link attachmentsLink = this.objectFactory.createLink();
            attachmentsLink.setHref(attachmentsUri);
            attachmentsLink.setRel("http://www.xwiki.org/rel/attachments");
            pageSummary.getLinks().add(attachmentsLink);
        }
        if (!doc.getxWikiObjects().keySet().isEmpty()) {
            String objectsUri = useVersion ? Utils.createURI(baseUri, ObjectsAtPageVersionResource.class, doc.getWiki(), spaces, doc.getDocumentReference().getName(), doc.getVersion()).toString() : Utils.createURI(baseUri, ObjectsResource.class, doc.getWiki(), spaces, doc.getDocumentReference().getName()).toString();
            Link objectsLink = this.objectFactory.createLink();
            objectsLink.setHref(objectsUri);
            objectsLink.setRel("http://www.xwiki.org/rel/objects");
            pageSummary.getLinks().add(objectsLink);
        }
        if ((tagsObject = doc.getObject("XWiki.TagClass", 0)) != null && tagsObject.getProperty("tags") != null) {
            String tagsUri = Utils.createURI(baseUri, PageTagsResource.class, doc.getWiki(), spaces, doc.getDocumentReference().getName()).toString();
            Link tagsLink = this.objectFactory.createLink();
            tagsLink.setHref(tagsUri);
            tagsLink.setRel("http://www.xwiki.org/rel/tags");
            pageSummary.getLinks().add(tagsLink);
        }
        String syntaxesUri = Utils.createURI(baseUri, SyntaxesResource.class, new java.lang.Object[0]).toString();
        Link syntaxesLink = this.objectFactory.createLink();
        syntaxesLink.setHref(syntaxesUri);
        syntaxesLink.setRel("http://www.xwiki.org/rel/syntaxes");
        pageSummary.getLinks().add(syntaxesLink);
    }

    public PageSummary toRestPageSummary(URI baseUri, Document doc, Boolean withPrettyNames) throws XWikiException {
        PageSummary pageSummary = this.objectFactory.createPageSummary();
        this.toRestPageSummary(pageSummary, baseUri, doc, false, withPrettyNames);
        String pageUri = Utils.createURI(baseUri, PageResource.class, doc.getWiki(), Utils.getSpacesFromSpaceId(doc.getSpace()), doc.getDocumentReference().getName()).toString();
        Link pageLink = this.objectFactory.createLink();
        pageLink.setHref(pageUri);
        pageLink.setRel("http://www.xwiki.org/rel/page");
        pageSummary.getLinks().add(pageLink);
        return pageSummary;
    }

    public Page toRestPage(URI baseUri, URI self, Document doc, boolean useVersion, Boolean withPrettyNames, Boolean withObjects, Boolean withXClass, Boolean withAttachments) throws XWikiException {
        Class xwikiClass;
        Page page = this.objectFactory.createPage();
        this.toRestPageSummary((PageSummary)page, baseUri, doc, useVersion, withPrettyNames);
        XWikiContext xwikiContext = (XWikiContext)this.xcontextProvider.get();
        page.setMajorVersion(doc.getRCSVersion().at(0));
        page.setMinorVersion(doc.getRCSVersion().at(1));
        page.setHidden(doc.isHidden());
        page.setLanguage(doc.getLocale().toString());
        page.setCreator(doc.getCreator());
        if (withPrettyNames.booleanValue()) {
            page.setCreatorName(xwikiContext.getWiki().getUserName(doc.getCreator(), null, false, xwikiContext));
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(doc.getCreationDate());
        page.setCreated(calendar);
        page.setModifier(doc.getContentAuthor());
        if (withPrettyNames.booleanValue()) {
            page.setModifierName(xwikiContext.getWiki().getUserName(doc.getContentAuthor(), null, false, xwikiContext));
        }
        calendar = Calendar.getInstance();
        calendar.setTime(doc.getContentUpdateDate());
        page.setModified(calendar);
        page.setComment(doc.getComment());
        page.setContent(doc.getContent());
        page.setHierarchy(this.toRestHierarchy((EntityReference)doc.getDocumentReference(), withPrettyNames));
        if (self != null) {
            Link pageLink = this.objectFactory.createLink();
            pageLink.setHref(self.toString());
            pageLink.setRel("self");
            page.getLinks().add(pageLink);
        }
        if ((xwikiClass = doc.getxWikiClass()) != null) {
            String classUri = Utils.createURI(baseUri, ClassResource.class, doc.getWiki(), xwikiClass.getName()).toString();
            Link classLink = this.objectFactory.createLink();
            classLink.setHref(classUri);
            classLink.setRel("http://www.xwiki.org/rel/class");
            page.getLinks().add(classLink);
        }
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        if (withAttachments.booleanValue()) {
            page.setAttachments(this.objectFactory.createAttachments());
            for (Attachment attachment : doc.getAttachmentList()) {
                URL url = xcontext.getURLFactory().createAttachmentURL(attachment.getFilename(), doc.getSpace(), doc.getDocumentReference().getName(), "download", null, doc.getWiki(), xcontext);
                String attachmentXWikiAbsoluteUrl = url.toString();
                String attachmentXWikiRelativeUrl = xcontext.getURLFactory().getURL(url, xcontext);
                page.getAttachments().getAttachments().add(this.toRestAttachment(baseUri, attachment, attachmentXWikiRelativeUrl, attachmentXWikiAbsoluteUrl, withPrettyNames, false));
            }
        }
        if (withObjects.booleanValue()) {
            page.setObjects(this.objectFactory.createObjects());
            XWikiDocument xwikiDocument = xcontext.getWiki().getDocument(doc.getDocumentReference(), xcontext);
            for (List objects : xwikiDocument.getXObjects().values()) {
                for (BaseObject object : objects) {
                    if (object == null) continue;
                    page.getObjects().getObjectSummaries().add(this.toRestObject(baseUri, doc, object, false, withPrettyNames));
                }
            }
        }
        if (withXClass.booleanValue()) {
            page.setClazz(this.toRestClass(baseUri, doc.getxWikiClass()));
        }
        return page;
    }

    public org.xwiki.rest.model.jaxb.Class toRestClass(URI baseUri, Class xwikiClass) {
        org.xwiki.rest.model.jaxb.Class clazz = this.objectFactory.createClass();
        clazz.setId(xwikiClass.getName());
        clazz.setName(xwikiClass.getName());
        DocumentReference reference = xwikiClass.getReference();
        String wikiName = reference.getWikiReference().getName();
        for (Element xwikiPropertyClassObject : xwikiClass.getProperties()) {
            com.xpn.xwiki.api.PropertyClass xwikiPropertyClass = (com.xpn.xwiki.api.PropertyClass)xwikiPropertyClassObject;
            Property property = this.objectFactory.createProperty();
            property.setName(xwikiPropertyClass.getName());
            property.setType(xwikiPropertyClass.getxWikiClass().getName());
            for (Element xwikiPropertyObject : xwikiPropertyClass.getProperties()) {
                com.xpn.xwiki.api.Property xwikiProperty = (com.xpn.xwiki.api.Property)xwikiPropertyObject;
                java.lang.Object value = xwikiProperty.getValue();
                Attribute attribute = this.objectFactory.createAttribute();
                attribute.setName(xwikiProperty.getName());
                if (value != null) {
                    attribute.setValue(value.toString());
                } else {
                    attribute.setValue("");
                }
                property.getAttributes().add(attribute);
            }
            String propertyUri = Utils.createURI(baseUri, ClassPropertyResource.class, wikiName, xwikiClass.getName(), xwikiPropertyClass.getName()).toString();
            Link propertyLink = this.objectFactory.createLink();
            propertyLink.setHref(propertyUri);
            propertyLink.setRel("self");
            property.getLinks().add(propertyLink);
            clazz.getProperties().add(property);
        }
        String classUri = Utils.createURI(baseUri, ClassResource.class, wikiName, xwikiClass.getName()).toString();
        Link classLink = this.objectFactory.createLink();
        classLink.setHref(classUri);
        classLink.setRel("self");
        clazz.getLinks().add(classLink);
        String propertiesUri = Utils.createURI(baseUri, ClassPropertiesResource.class, wikiName, xwikiClass.getName()).toString();
        Link propertyLink = this.objectFactory.createLink();
        propertyLink.setHref(propertiesUri);
        propertyLink.setRel("http://www.xwiki.org/rel/properties");
        clazz.getLinks().add(propertyLink);
        String objectsUri = Utils.createURI(baseUri, AllObjectsForClassNameResource.class, wikiName, xwikiClass.getName()).toString();
        Link objectsLink = this.objectFactory.createLink();
        objectsLink.setHref(objectsUri);
        objectsLink.setRel("http://www.xwiki.org/rel/objects");
        clazz.getLinks().add(objectsLink);
        return clazz;
    }

    public org.xwiki.rest.model.jaxb.Attachment toRestAttachment(URI baseUri, Attachment xwikiAttachment, Boolean withPrettyNames, boolean versionURL) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        String relativeURL = xcontext.getWiki().getURL((EntityReference)xwikiAttachment.getReference(), xcontext);
        String absoluteURL = xcontext.getWiki().getExternalAttachmentURL(xwikiAttachment.getDocument().getFullName(), xwikiAttachment.getFilename(), xcontext);
        return this.toRestAttachment(baseUri, xwikiAttachment, relativeURL, absoluteURL, withPrettyNames, versionURL);
    }

    public org.xwiki.rest.model.jaxb.Attachment toRestAttachment(URI baseUri, Attachment xwikiAttachment, String xwikiRelativeUrl, String xwikiAbsoluteUrl, Boolean withPrettyNames, boolean versionURL) {
        org.xwiki.rest.model.jaxb.Attachment attachment = this.objectFactory.createAttachment();
        DocumentReference documentReference = xwikiAttachment.getReference().getDocumentReference();
        attachment.setPageId((String)this.defaultEntityReferenceSerializer.serialize((EntityReference)documentReference, new java.lang.Object[0]));
        attachment.setPageVersion(xwikiAttachment.getDocument().getVersion());
        attachment.setId((String)this.defaultEntityReferenceSerializer.serialize((EntityReference)xwikiAttachment.getReference(), new java.lang.Object[0]));
        attachment.setName(xwikiAttachment.getFilename());
        attachment.setLongSize(xwikiAttachment.getLongSize());
        attachment.setSize((int)xwikiAttachment.getLongSize());
        attachment.setVersion(xwikiAttachment.getVersion());
        attachment.setMimeType(xwikiAttachment.getMimeType());
        attachment.setAuthor(xwikiAttachment.getAuthor());
        if (withPrettyNames.booleanValue()) {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            attachment.setAuthorName(xcontext.getWiki().getUserName(xwikiAttachment.getAuthor(), null, false, xcontext));
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(xwikiAttachment.getDate());
        attachment.setDate(calendar);
        attachment.setXwikiRelativeUrl(xwikiRelativeUrl);
        attachment.setXwikiAbsoluteUrl(xwikiAbsoluteUrl);
        attachment.setHierarchy(this.toRestHierarchy((EntityReference)xwikiAttachment.getReference(), withPrettyNames));
        String wiki = documentReference.getWikiReference().getName();
        List<String> spaces = Utils.getSpacesHierarchy(documentReference.getLastSpaceReference());
        String pageUri = Utils.createURI(baseUri, PageResource.class, wiki, spaces, documentReference.getName()).toString();
        Link pageLink = this.objectFactory.createLink();
        pageLink.setHref(pageUri);
        pageLink.setRel("http://www.xwiki.org/rel/page");
        attachment.getLinks().add(pageLink);
        String attachmentUri = versionURL ? Utils.createURI(baseUri, AttachmentVersionResource.class, wiki, spaces, documentReference.getName(), xwikiAttachment.getFilename(), xwikiAttachment.getVersion()).toString() : Utils.createURI(baseUri, AttachmentResource.class, wiki, spaces, documentReference.getName(), xwikiAttachment.getFilename()).toString();
        Link attachmentLink = this.objectFactory.createLink();
        attachmentLink.setHref(attachmentUri);
        attachmentLink.setRel("http://www.xwiki.org/rel/attachmentData");
        attachment.getLinks().add(attachmentLink);
        Link attachmentMetadataLink = this.objectFactory.createLink();
        attachmentMetadataLink.setHref(Utils.createURI(baseUri, AttachmentMetadataResource.class, wiki, spaces, documentReference.getName(), xwikiAttachment.getFilename()).toString());
        attachmentMetadataLink.setRel("http://www.xwiki.org/rel/attachmentMetadata");
        attachment.getLinks().add(attachmentMetadataLink);
        return attachment;
    }

    public Hierarchy toRestHierarchy(EntityReference targetEntityReference, Boolean withPrettyNames) {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = xcontext.getWiki();
        Hierarchy hierarchy = new Hierarchy();
        for (EntityReference entityReference : targetEntityReference.getReversedReferenceChain()) {
            HierarchyItem hierarchyItem = new HierarchyItem();
            hierarchyItem.setName(entityReference.getName());
            hierarchyItem.setLabel(entityReference.getName());
            hierarchyItem.setType(entityReference.getType().getLowerCase());
            hierarchyItem.setUrl(xwiki.getURL(entityReference, xcontext));
            if (withPrettyNames.booleanValue()) {
                try {
                    WikiDescriptor wikiDescriptor;
                    if (entityReference.getType() == EntityType.SPACE || entityReference.getType() == EntityType.DOCUMENT) {
                        XWikiDocument document = xwiki.getDocument(entityReference, xcontext).getTranslatedDocument(xcontext);
                        hierarchyItem.setLabel(document.getRenderedTitle(Syntax.PLAIN_1_0, xcontext));
                        hierarchyItem.setUrl(xwiki.getURL((EntityReference)document.getDocumentReferenceWithLocale(), xcontext));
                    } else if (entityReference.getType() == EntityType.WIKI && (wikiDescriptor = this.wikiDescriptorManager.getById(entityReference.getName())) != null) {
                        hierarchyItem.setLabel(wikiDescriptor.getPrettyName());
                    }
                }
                catch (Exception e) {
                    this.logger.warn("Failed to get the pretty name of entity [{}]. Continue using the entity name. Root cause is [{}].", (java.lang.Object)entityReference, (java.lang.Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                }
            }
            hierarchy.withItems(new HierarchyItem[]{hierarchyItem});
        }
        return hierarchy;
    }

    private static String serializePropertyValue(PropertyInterface property) {
        if (property == null) {
            return "";
        }
        java.lang.Object value = ((BaseProperty)property).getValue();
        if (value instanceof List) {
            return StringUtils.join((Iterable)((List)value), (String)"|");
        }
        if (value != null) {
            return value.toString();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String serializePropertyValue(PropertyInterface property, PropertyClass propertyClass, XWikiContext context) {
        if (propertyClass instanceof ComputedFieldClass) {
            XWikiDocument document = context.getDoc();
            try {
                context.setDoc(property.getObject().getOwnerDocument());
                ComputedFieldClass computedFieldClass = (ComputedFieldClass)propertyClass;
                String string = computedFieldClass.getComputedValue(propertyClass.getName(), "", property.getObject(), context);
                return string;
            }
            catch (Exception e) {
                this.logger.error("Error while computing property value [{}] of [{}]", new java.lang.Object[]{propertyClass.getName(), property.getObject(), e});
                String string = ModelFactory.serializePropertyValue(property);
                return string;
            }
            finally {
                context.setDoc(document);
            }
        }
        return ModelFactory.serializePropertyValue(property);
    }

    public JobRequest toRestJobRequest(Request request) throws XWikiRestException {
        JobRequest restJobRequest = this.objectFactory.createJobRequest();
        restJobRequest.setId(this.toRestJobId(request.getId()));
        restJobRequest.setInteractive(request.isInteractive());
        restJobRequest.setRemote(request.isRemote());
        restJobRequest.setVerbose(request.isVerbose());
        restJobRequest.setStatusSerialized(request.isStatusSerialized());
        restJobRequest.setStatusLogIsolated(request.isStatusLogIsolated());
        for (String key : request.getPropertyNames()) {
            restJobRequest.getProperties().add(this.toRestMapEntry(key, request.getProperty(key)));
        }
        return restJobRequest;
    }

    public JobId toRestJobId(List<String> id) {
        if (id == null) {
            return null;
        }
        JobId restJobId = this.objectFactory.createJobId();
        restJobId.withElements(id);
        return restJobId;
    }

    public MapEntry toRestMapEntry(String key, java.lang.Object value) throws XWikiRestException {
        MapEntry restMapEntry = this.objectFactory.createMapEntry();
        restMapEntry.setKey(key);
        try {
            restMapEntry.setValue(this.jaxbConverter.serializeAny(value));
        }
        catch (ParserConfigurationException e) {
            throw new XWikiRestException("Failed to serialize property [" + key + "] with value [" + value + "]", (Throwable)e);
        }
        return restMapEntry;
    }

    public DefaultRequest toJobRequest(JobRequest restJobRequest) {
        DefaultRequest request = new DefaultRequest();
        if (restJobRequest.getId() != null) {
            request.setId(restJobRequest.getId().getElements());
        }
        request.setInteractive(restJobRequest.isInteractive());
        request.setVerbose(restJobRequest.isVerbose());
        request.setStatusSerialized(restJobRequest.isStatusSerialized());
        request.setStatusLogIsolated(restJobRequest.isStatusLogIsolated());
        for (MapEntry restEntry : restJobRequest.getProperties()) {
            request.setProperty(restEntry.getKey(), this.jaxbConverter.unserializeAny(restEntry.getValue()));
        }
        return request;
    }

    public JobStatus toRestJobStatus(org.xwiki.job.event.status.JobStatus jobStatus, URI self, boolean request, boolean progress, boolean log, String logFromLevel) throws XWikiRestException {
        JobStatus status = this.objectFactory.createJobStatus();
        status.setId(StringUtils.join((Iterable)jobStatus.getRequest().getId(), (String)"/"));
        status.setState(jobStatus.getState().name());
        if (jobStatus.getStartDate() != null) {
            Calendar calendarStartDate = Calendar.getInstance();
            calendarStartDate.setTime(jobStatus.getStartDate());
            status.setStartDate(calendarStartDate);
        }
        if (jobStatus.getEndDate() != null) {
            Calendar calendarEndDate = Calendar.getInstance();
            calendarEndDate.setTime(jobStatus.getEndDate());
            status.setEndDate(calendarEndDate);
        }
        if (jobStatus.getError() != null) {
            status.setErrorMessage(ExceptionUtils.getStackTrace((Throwable)jobStatus.getError()));
        }
        if (request) {
            status.setRequest(this.toRestJobRequest(jobStatus.getRequest()));
        }
        if (progress) {
            status.setProgress(this.toRestJobProgress(jobStatus.getProgress()));
        }
        if (log) {
            try {
                status.setLog(this.toRestJobLog(jobStatus.getLogTail(), self, null, logFromLevel));
            }
            catch (IOException e) {
                this.logger.error("Failed to access the log of job {}", (java.lang.Object)jobStatus.getRequest().getId(), (java.lang.Object)e);
            }
        }
        if (self != null) {
            Link link = this.objectFactory.createLink();
            link.setHref(self.toString());
            link.setRel("self");
            status.getLinks().add(link);
        }
        status.setIsolated(Boolean.valueOf(jobStatus.isIsolated()));
        status.setSerialized(Boolean.valueOf(jobStatus.isSerialized()));
        return status;
    }

    public JobProgress toRestJobProgress(org.xwiki.job.event.status.JobProgress progress) {
        JobProgress restJobProgress = this.objectFactory.createJobProgress();
        restJobProgress.setOffset(progress.getOffset());
        restJobProgress.setCurrentLevelOffset(progress.getCurrentLevelOffset());
        return restJobProgress;
    }

    public JobLog toRestJobLog(LogTail logQueue, URI self, String level, String fromLevel) throws IOException {
        java.lang.Object logs;
        if (level != null) {
            LogLevel logLevel = LogLevel.valueOf((String)level.toUpperCase());
            logs = logQueue.getLogEvents(logLevel).stream().filter(log -> log.getLevel() == logLevel).collect(Collectors.toList());
        } else {
            logs = fromLevel != null ? logQueue.getLogEvents(LogLevel.valueOf((String)fromLevel.toUpperCase())) : logQueue;
        }
        return this.toRestJobLog((Iterable<org.xwiki.logging.event.LogEvent>)logs, self);
    }

    public JobLog toRestJobLog(Iterable<org.xwiki.logging.event.LogEvent> logs, URI self) {
        JobLog log = this.objectFactory.createJobLog();
        for (org.xwiki.logging.event.LogEvent logEvent : logs) {
            LogEvent event = this.objectFactory.createLogEvent();
            event.setLevel(logEvent.getLevel().name());
            Calendar calendarDate = Calendar.getInstance();
            calendarDate.setTimeInMillis(logEvent.getTimeStamp());
            event.setDate(calendarDate);
            event.setFormattedMessage(logEvent.getFormattedMessage());
            log.getLogEvents().add(event);
        }
        if (self != null) {
            Link link = this.objectFactory.createLink();
            link.setHref(self.toString());
            link.setRel("self");
            log.getLinks().add(link);
        }
        return log;
    }

    private boolean hasAccess(Property restProperty) {
        if (PASSWORD_TYPE.equals(restProperty.getType())) {
            return ((ContextualAuthorizationManager)this.authorizationManagerProvider.get()).hasAccess(Right.ADMIN, (EntityReference)((XWikiContext)this.xcontextProvider.get()).getWikiReference());
        }
        return true;
    }
}

