/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.classes;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.PropertyInterface;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.PropertyClass;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.reference.ClassPropertyReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.model.jaxb.PropertyValue;
import org.xwiki.rest.model.jaxb.PropertyValues;
import org.xwiki.rest.resources.classes.ClassPropertyValuesProvider;

@Component
@Singleton
public class DefaultClassPropertyValuesProvider
implements ClassPropertyValuesProvider {
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;

    public PropertyValues getValues(ClassPropertyReference propertyReference, int limit, Object ... filterParameters) throws XWikiRestException {
        return this.getDedicatedProvider(this.getPropertyType(propertyReference)).getValues(propertyReference, limit, filterParameters);
    }

    public PropertyValue getValue(ClassPropertyReference propertyReference, Object rawValue) throws XWikiRestException {
        return this.getDedicatedProvider(this.getPropertyType(propertyReference)).getValue(propertyReference, rawValue);
    }

    private ClassPropertyValuesProvider getDedicatedProvider(String propertyType) throws XWikiRestException {
        try {
            return (ClassPropertyValuesProvider)this.componentManager.getInstance(ClassPropertyValuesProvider.class, propertyType);
        }
        catch (ComponentLookupException e) {
            throw new XWikiRestException(String.format("There's no value provider registered for the [%s] property type.", propertyType));
        }
    }

    private String getPropertyType(ClassPropertyReference propertyReference) throws XWikiRestException {
        try {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            XWikiDocument document = xcontext.getWiki().getDocument(propertyReference.getParent(), xcontext);
            BaseClass xclass = document.getXClass();
            PropertyInterface xproperty = xclass.get(propertyReference.getName());
            if (xproperty instanceof PropertyClass) {
                return ((PropertyClass)xproperty).getClassType();
            }
            throw new XWikiRestException(String.format("No such property [%s].", this.entityReferenceSerializer.serialize((EntityReference)propertyReference, new Object[0])));
        }
        catch (XWikiException e) {
            throw new XWikiRestException(String.format("Failed to determine the property type for [{}].", this.entityReferenceSerializer.serialize((EntityReference)propertyReference, new Object[0])));
        }
    }
}

