/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.url.resources;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.internal.url.resources.AbstractEntityRestURLGenerator;
import org.xwiki.rest.resources.pages.PageResource;
import org.xwiki.rest.resources.pages.PageTranslationResource;

@Component
@Singleton
public class DocumentRestURLGenerator
extends AbstractEntityRestURLGenerator<DocumentReference> {
    @Override
    public URL getURL(DocumentReference reference) throws XWikiRestException {
        try {
            Locale locale = reference.getLocale();
            URL url = locale != null && !locale.toString().isEmpty() ? Utils.createURI(this.getBaseURI(), PageTranslationResource.class, reference.getWikiReference().getName(), this.getSpaceList(reference.getLastSpaceReference()), reference.getName(), reference.getLocale()).toURL() : Utils.createURI(this.getBaseURI(), PageResource.class, reference.getWikiReference().getName(), this.getSpaceList(reference.getLastSpaceReference()), reference.getName()).toURL();
            return url;
        }
        catch (MalformedURLException e) {
            throw new XWikiRestException(String.format("Failed to generate a REST URL for the document [%s].", reference), (Throwable)e);
        }
    }
}

