/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.rest.internal.resources.job;

import java.io.IOException;

import javax.inject.Inject;
import javax.inject.Named;

import org.xwiki.component.annotation.Component;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.rest.XWikiJobResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.ModelFactory;
import org.xwiki.rest.model.jaxb.JobLog;
import org.xwiki.rest.resources.job.JobLogResource;

/**
 * @version $Id: 930d13c5e8acdbe42db50a1a742622d5eaa74c93 $
 * @since 7.2M3
 */
@Component
@Named("org.xwiki.rest.internal.resources.job.JobLogResourceImpl")
public class JobLogResourceImpl extends XWikiJobResource implements JobLogResource
{
    @Inject
    private ModelFactory factory;

    @Override
    public JobLog getJobLog(String jobId, String level, String fromLevel) throws XWikiRestException
    {
        JobStatus jobStatus = getRealJobStatus(jobId);

        try {
            return this.factory.toRestJobLog(jobStatus.getLogTail(), this.uriInfo.getAbsolutePath(), level, fromLevel);
        } catch (IOException e) {
            throw new XWikiRestException("Failed to load the log for job [" + jobId + "]", e);
        }
    }
}
