/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.user.api.XWikiUser;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Form;
import org.restlet.security.ChallengeAuthenticator;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rest.internal.Utils;

public class XWikiAuthentication
extends ChallengeAuthenticator {
    public XWikiAuthentication(Context context) throws IllegalArgumentException {
        super(context, ChallengeScheme.HTTP_BASIC, "XWiki");
    }

    public boolean authenticate(Request request, Response response) {
        if (request.getResourceRef().getPath().endsWith("/browser_authentication")) {
            return super.authenticate(request, response);
        }
        ComponentManager componentManager = (ComponentManager)this.getContext().getAttributes().get("xwikiComponentManager");
        XWikiContext xwikiContext = Utils.getXWikiContext(componentManager);
        XWiki xwiki = Utils.getXWiki(componentManager);
        xwikiContext.setUser("XWiki.XWikiGuest");
        Form headers = (Form)request.getAttributes().get("org.restlet.http.headers");
        Form responseHeaders = (Form)response.getAttributes().get("org.restlet.http.headers");
        if (responseHeaders == null) {
            responseHeaders = new Form();
            response.getAttributes().put("org.restlet.http.headers", responseHeaders);
        }
        responseHeaders.add("XWiki-User", xwikiContext.getUser());
        responseHeaders.add("XWiki-Version", xwikiContext.getWiki().getVersion());
        if (headers.getValues("Authorization") == null) {
            try {
                XWikiUser xwikiUser = xwiki.getAuthService().checkAuth(xwikiContext);
                if (xwikiUser != null) {
                    xwikiContext.setUser(xwikiUser.getUser().contains(":") ? xwikiUser.getUser() : xwikiContext.getDatabase() + ':' + xwikiUser.getUser());
                    this.getLogger().log(Level.FINE, String.format("Authenticated as '%s'.", xwikiUser.getUser()));
                }
            }
            catch (XWikiException e) {
                this.getLogger().log(Level.WARNING, "Exception occurred while authenticating.", e);
            }
            responseHeaders.set("XWiki-User", xwikiContext.getUser());
            return true;
        }
        return super.authenticate(request, response);
    }
}

