/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.tags;

import com.xpn.xwiki.api.Document;
import java.util.ArrayList;
import java.util.List;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.QueryException;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.DomainObjectFactory;
import org.xwiki.rest.internal.RangeIterable;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Pages;
import org.xwiki.rest.resources.tags.PagesForTagsResource;

@Component(value="org.xwiki.rest.internal.resources.tags.PagesForTagsResourceImpl")
public class PagesForTagsResourceImpl
extends XWikiResource
implements PagesForTagsResource {
    public Pages getTags(String wikiName, String tagNames, Integer start, Integer number, Boolean withPrettyNames) throws XWikiRestException {
        String database = Utils.getXWikiContext(this.componentManager).getDatabase();
        try {
            Pages pages = this.objectFactory.createPages();
            Utils.getXWikiContext(this.componentManager).setDatabase(wikiName);
            String[] tagNamesArray = tagNames.split(",");
            ArrayList<String> documentNames = new ArrayList<String>();
            for (String tagName : tagNamesArray) {
                List<String> documentNamesForTag = this.getDocumentsWithTag(tagName);
                for (String documentName : documentNamesForTag) {
                    if (documentNames.contains(documentName)) continue;
                    documentNames.add(documentName);
                }
            }
            RangeIterable ri = new RangeIterable(documentNames, start, number);
            for (String documentName : ri) {
                Document doc = Utils.getXWikiApi(this.componentManager).getDocument(documentName);
                if (doc == null) continue;
                pages.getPageSummaries().add(DomainObjectFactory.createPageSummary(this.objectFactory, this.uriInfo.getBaseUri(), doc, Utils.getXWikiApi(this.componentManager), withPrettyNames));
            }
            Pages pages2 = pages;
            return pages2;
        }
        catch (Exception e) {
            throw new XWikiRestException((Throwable)e);
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setDatabase(database);
        }
    }

    private List<String> getDocumentsWithTag(String tag) throws QueryException {
        String query = "select doc.fullName from XWikiDocument as doc, BaseObject as obj, DBStringListProperty as prop where obj.name=doc.fullName and obj.className='XWiki.TagClass' and obj.id=prop.id.id and prop.id.name='tags' and :tag in elements(prop.list) order by doc.name asc";
        List documentsWithTag = this.queryManager.createQuery(query, "hql").bindValue("tag", (Object)tag).execute();
        return documentsWithTag;
    }
}

