/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.spaces;

import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.XWiki;
import java.util.List;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.QueryFilter;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.DomainObjectFactory;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Spaces;
import org.xwiki.rest.resources.spaces.SpacesResource;

@Component(value="org.xwiki.rest.internal.resources.spaces.SpacesResourceImpl")
public class SpacesResourceImpl
extends XWikiResource
implements SpacesResource {
    public Spaces getSpaces(String wikiName, Integer start, Integer number) throws XWikiRestException {
        String database = Utils.getXWikiContext(this.componentManager).getWikiId();
        Spaces spaces = this.objectFactory.createSpaces();
        try {
            Utils.getXWikiContext(this.componentManager).setWikiId(wikiName);
            List spaceNames = this.queryManager.getNamedQuery("getSpaces").addFilter((QueryFilter)this.componentManager.getInstance(QueryFilter.class, "hidden")).setOffset(start.intValue()).setLimit(number.intValue()).execute();
            for (String spaceName : spaceNames) {
                String homeId = Utils.getPageId(wikiName, spaceName, "WebHome");
                Document home = null;
                XWiki xwikiApi = Utils.getXWikiApi(this.componentManager);
                if (!xwikiApi.hasAccessLevel("view", homeId)) continue;
                if (xwikiApi.exists(homeId)) {
                    home = Utils.getXWikiApi(this.componentManager).getDocument(homeId);
                }
                spaces.getSpaces().add(DomainObjectFactory.createSpace(this.objectFactory, this.uriInfo.getBaseUri(), wikiName, spaceName, home));
            }
        }
        catch (Exception e) {
            throw new XWikiRestException((Throwable)e);
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setWikiId(database);
        }
        return spaces;
    }
}

