/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.wikis;

import javax.inject.Inject;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceValueProvider;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.DomainObjectFactory;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.Wikis;
import org.xwiki.rest.resources.wikis.WikisResource;
import org.xwiki.rest.resources.wikis.WikisSearchQueryResource;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.user.MembershipType;
import org.xwiki.wiki.user.UserScope;
import org.xwiki.wiki.user.WikiUserManager;

@Component(value="org.xwiki.rest.internal.resources.wikis.WikisResourceImpl")
public class WikisResourceImpl
extends XWikiResource
implements WikisResource {
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private ContextualAuthorizationManager authorizationManager;
    @Inject
    private WikiUserManager wikiUserManager;
    @Inject
    private EntityReferenceValueProvider defaultEntityReferenceValueProvider;

    public Wikis getWikis() throws XWikiRestException {
        try {
            Wikis wikis = this.objectFactory.createWikis();
            for (String wikiId : this.wikiDescriptorManager.getAllIds()) {
                EntityReference absoluteCommentReference = new EntityReference(this.defaultEntityReferenceValueProvider.getDefaultValue(EntityType.DOCUMENT), EntityType.DOCUMENT, new EntityReference("XWiki", EntityType.SPACE, new EntityReference(wikiId, EntityType.WIKI)));
                DocumentReference currentUserReference = this.getXWikiContext().getUserReference();
                if (!this.authorizationManager.hasAccess(Right.VIEW, absoluteCommentReference) && (this.wikiUserManager.getUserScope(wikiId) == UserScope.LOCAL_ONLY || this.wikiUserManager.getMembershipType(wikiId) == MembershipType.INVITE) && !this.wikiUserManager.hasPendingInvitation(currentUserReference, wikiId)) continue;
                wikis.getWikis().add(DomainObjectFactory.createWiki(this.objectFactory, this.uriInfo.getBaseUri(), wikiId));
            }
            String queryUri = Utils.createURI(this.uriInfo.getBaseUri(), WikisSearchQueryResource.class, new Object[0]).toString();
            Link queryLink = this.objectFactory.createLink();
            queryLink.setHref(queryUri);
            queryLink.setRel("http://www.xwiki.org/rel/query");
            wikis.getLinks().add(queryLink);
            return wikis;
        }
        catch (Exception e) {
            throw new XWikiRestException("Failed to get the list of wikis", (Throwable)e);
        }
    }
}

