/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.representations.comments;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.restlet.Context;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.representation.InputRepresentation;
import org.restlet.representation.Representation;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.XWikiRestComponent;
import org.xwiki.rest.model.jaxb.Comment;
import org.xwiki.rest.model.jaxb.ObjectFactory;

@Component
@Named(value="org.xwiki.rest.internal.representations.comments.FormUrlEncodedCommentReader")
@Provider
@Consumes(value={"application/x-www-form-urlencoded"})
@Singleton
public class FormUrlEncodedCommentReader
implements MessageBodyReader<Comment>,
XWikiRestComponent {
    private static final String COMMENT_TEXT_FIELD_NAME = "text";
    private static final String COMMENT_REPLYTO_FIELD_NAME = "replyTo";

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, javax.ws.rs.core.MediaType mediaType) {
        return Comment.class.isAssignableFrom(type);
    }

    public Comment readFrom(Class<Comment> type, Type genericType, Annotation[] annotations, javax.ws.rs.core.MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        ObjectFactory objectFactory = new ObjectFactory();
        Comment comment = objectFactory.createComment();
        HttpServletRequest httpServletRequest = (HttpServletRequest)Context.getCurrent().getAttributes().get("httpRequest");
        InputRepresentation representation = new InputRepresentation(entityStream, MediaType.APPLICATION_WWW_FORM);
        Form form = new Form((Representation)representation);
        if (form.getNames().isEmpty()) {
            try {
                comment.setReplyTo(Integer.valueOf(Integer.parseInt(httpServletRequest.getParameter(COMMENT_REPLYTO_FIELD_NAME))));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            comment.setText(httpServletRequest.getParameter(COMMENT_TEXT_FIELD_NAME));
        } else {
            try {
                comment.setReplyTo(Integer.valueOf(Integer.parseInt(form.getFirstValue(COMMENT_REPLYTO_FIELD_NAME))));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            comment.setText(form.getFirstValue(COMMENT_TEXT_FIELD_NAME));
        }
        return comment;
    }
}

