/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.comments;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.Object;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.inject.Named;
import javax.ws.rs.core.Response;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.DomainObjectFactory;
import org.xwiki.rest.internal.RangeIterable;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Comment;
import org.xwiki.rest.model.jaxb.Comments;
import org.xwiki.rest.resources.comments.CommentResource;
import org.xwiki.rest.resources.comments.CommentsResource;

@Component
@Named(value="org.xwiki.rest.internal.resources.comments.CommentsResourceImpl")
public class CommentsResourceImpl
extends XWikiResource
implements CommentsResource {
    public Comments getComments(String wikiName, String spaceName, String pageName, Integer start, Integer number, Boolean withPrettyNames) throws XWikiRestException {
        try {
            XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, false);
            Document doc = documentInfo.getDocument();
            Comments comments = this.objectFactory.createComments();
            Vector xwikiComments = doc.getComments();
            RangeIterable ri = new RangeIterable(xwikiComments, start, number);
            for (Object xwikiComment : ri) {
                comments.getComments().add(DomainObjectFactory.createComment(this.objectFactory, this.uriInfo.getBaseUri(), doc, xwikiComment, Utils.getXWikiApi(this.componentManager), withPrettyNames));
            }
            return comments;
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }

    public Response postComment(String wikiName, String spaceName, String pageName, Comment comment) throws XWikiRestException {
        try {
            List<String> spaces = this.parseSpaceSegments(spaceName);
            XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaces, pageName, null, null, true, true);
            Document doc = documentInfo.getDocument();
            int id = doc.createNewObject("XWiki.XWikiComments");
            Object commentObject = doc.getObject("XWiki.XWikiComments", id);
            commentObject.set("author", (java.lang.Object)Utils.getXWikiUser(this.componentManager));
            commentObject.set("date", (java.lang.Object)new Date());
            boolean save = false;
            if (comment.getHighlight() != null) {
                commentObject.set("highlight", (java.lang.Object)comment.getHighlight());
                save = true;
            }
            if (comment.getText() != null) {
                commentObject.set("comment", (java.lang.Object)comment.getText());
                save = true;
            }
            if (comment.getReplyTo() != null) {
                commentObject.set("replyto", (java.lang.Object)comment.getReplyTo());
            }
            if (save) {
                doc.save();
                Comment createdComment = DomainObjectFactory.createComment(this.objectFactory, this.uriInfo.getBaseUri(), doc, commentObject, Utils.getXWikiApi(this.componentManager), false);
                return Response.created((URI)Utils.createURI(this.uriInfo.getBaseUri(), CommentResource.class, wikiName, spaces, pageName, id)).entity((java.lang.Object)createdComment).build();
            }
            return null;
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }
}

