/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.spaces;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import java.util.List;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.DomainObjectFactory;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Space;
import org.xwiki.rest.resources.spaces.SpaceResource;

@Component
@Named(value="org.xwiki.rest.internal.resources.spaces.SpaceResourceImpl")
public class SpaceResourceImpl
extends XWikiResource
implements SpaceResource {
    public Space getSpace(String wikiName, String spaceName) throws XWikiRestException {
        String database = Utils.getXWikiContext(this.componentManager).getWikiId();
        List<String> spaces = this.parseSpaceSegments(spaceName);
        try {
            Utils.getXWikiContext(this.componentManager).setWikiId(wikiName);
            String homeId = Utils.getPageId(wikiName, spaces, "WebHome");
            Document home = null;
            if (Utils.getXWikiApi(this.componentManager).exists(homeId)) {
                home = Utils.getXWikiApi(this.componentManager).getDocument(homeId);
            }
            Space space = DomainObjectFactory.createSpace(this.objectFactory, this.uriInfo.getBaseUri(), wikiName, spaces, home);
            return space;
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setWikiId(database);
        }
    }
}

