/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.spaces;

import java.util.List;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.internal.resources.BaseSearchResult;
import org.xwiki.rest.model.jaxb.SearchResults;
import org.xwiki.rest.resources.spaces.SpaceSearchResource;

@Component
@Named(value="org.xwiki.rest.internal.resources.spaces.SpaceSearchResourceImpl")
public class SpaceSearchResourceImpl
extends BaseSearchResult
implements SpaceSearchResource {
    public SearchResults search(String wikiName, String spaceName, String keywords, List<String> searchScopeStrings, Integer number, Integer start, String orderField, String order, Boolean withPrettyNames) throws XWikiRestException {
        List<String> spaces = this.parseSpaceSegments(spaceName);
        try {
            SearchResults searchResults = this.objectFactory.createSearchResults();
            searchResults.setTemplate(String.format("%s?%s", Utils.createURI(this.uriInfo.getBaseUri(), SpaceSearchResource.class, wikiName, spaces).toString(), "q={keywords}(&scope={content|name|title|spaces|objects})*(&number={number})(&start={start})(&orderField={fieldname}(&order={asc|desc}))(&prettyNames={false|true})"));
            List<BaseSearchResult.SearchScope> searchScopes = this.parseSearchScopeStrings(searchScopeStrings);
            searchResults.getSearchResults().addAll(this.search(searchScopes, keywords, wikiName, Utils.getLocalSpaceId(spaces), Utils.getXWiki(this.componentManager).getRightService().hasProgrammingRights(Utils.getXWikiContext(this.componentManager)), number, start, true, orderField, order, withPrettyNames));
            return searchResults;
        }
        catch (Exception e) {
            throw new XWikiRestException((Throwable)e);
        }
    }
}

