/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.scheduler.internal;

import com.xpn.xwiki.doc.AbstractMandatoryClassInitializer;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.TextAreaClass;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.sheet.SheetBinder;

@Component
@Named(value="XWiki.SchedulerJobClass")
@Singleton
public class SchedulerJobClassDocumentInitializer
extends AbstractMandatoryClassInitializer {
    public static final String SHEET_NAME = "SchedulerJobSheet";
    public static final LocalDocumentReference XWIKI_JOB_CLASSREFERENCE = new LocalDocumentReference("XWiki", "SchedulerJobClass");
    private static final String FIELD_JOBNAME = "jobName";
    private static final String FIELD_JOBDESCRIPTION = "jobDescription";
    private static final String FIELD_JOBCLASS = "jobClass";
    private static final String FIELD_STATUS = "status";
    private static final String FIELD_CRON = "cron";
    private static final String FIELD_SCRIPT = "script";
    private static final String FIELD_CONTEXTUSER = "contextUser";
    private static final String FIELD_CONTEXTLANG = "contextLang";
    private static final String FIELD_CONTEXTDATABASE = "contextDatabase";
    @Inject
    @Named(value="class")
    private SheetBinder classSheetBinder;

    public SchedulerJobClassDocumentInitializer() {
        super((EntityReference)XWIKI_JOB_CLASSREFERENCE);
    }

    protected void createClass(BaseClass xclass) {
        xclass.addTextField(FIELD_JOBNAME, "Job Name", 60);
        xclass.addTextAreaField(FIELD_JOBDESCRIPTION, "Job Description", 45, 10);
        xclass.addTextField(FIELD_JOBCLASS, "Job Class", 60);
        xclass.addTextField(FIELD_STATUS, "Status", 30);
        xclass.addTextField(FIELD_CRON, "Cron Expression", 30);
        xclass.addTextAreaField(FIELD_SCRIPT, "Job Script", 60, 10, TextAreaClass.ContentType.PURE_TEXT);
        xclass.addTextField(FIELD_CONTEXTUSER, "Job execution context user", 30);
        xclass.addTextField(FIELD_CONTEXTLANG, "Job execution context lang", 30);
        xclass.addTextField(FIELD_CONTEXTDATABASE, "Job execution context database", 30);
    }

    public boolean updateDocument(XWikiDocument document) {
        super.updateDocument(document);
        if (this.classSheetBinder.getSheets((DocumentModelBridge)document).isEmpty()) {
            String wikiName = document.getDocumentReference().getWikiReference().getName();
            DocumentReference sheet = new DocumentReference(wikiName, "XWiki", SHEET_NAME);
            return this.classSheetBinder.bind((DocumentModelBridge)document, sheet);
        }
        return false;
    }
}

