/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.lucene.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.PropertyInterface;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.DateClass;
import com.xpn.xwiki.objects.classes.ListItem;
import com.xpn.xwiki.objects.classes.PasswordClass;
import com.xpn.xwiki.objects.classes.StaticListClass;
import com.xpn.xwiki.plugin.lucene.internal.AbstractDocumentData;
import com.xpn.xwiki.plugin.lucene.internal.IndexFields;
import com.xpn.xwiki.web.Utils;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

public class DocumentData
extends AbstractDocumentData {
    private static final float CLASSNAME_BOOST = 0.5f;
    private static final float OBJECT_PROPERTY_BOOST = 0.75f;
    private EntityReferenceSerializer<String> localEntityReferenceSerializer = (EntityReferenceSerializer)Utils.getComponent((Type)EntityReferenceSerializer.TYPE_STRING, (String)"local");

    public DocumentData(XWikiDocument doc, XWikiContext context, boolean deleted) {
        super("wikipage", doc, context, deleted);
        this.setAuthor(doc.getAuthor());
        this.setCreator(doc.getCreator());
        this.setModificationDate(doc.getDate());
        this.setCreationDate(doc.getCreationDate());
    }

    @Override
    protected void getFullText(StringBuilder sb, XWikiDocument doc, XWikiContext context) {
        super.getFullText(sb, doc, context);
        sb.append(" ");
        sb.append(StringUtils.lowerCase((String)doc.getContent()));
        sb.append(" ");
        this.getObjectFullText(sb, doc, context);
    }

    private void getObjectFullText(StringBuilder sb, XWikiDocument doc, XWikiContext context) {
        this.getObjectContentAsText(sb, doc, context);
    }

    private void getObjectContentAsText(StringBuilder sb, XWikiDocument doc, XWikiContext context) {
        for (List objects : doc.getXObjects().values()) {
            for (BaseObject obj : objects) {
                this.extractObjectContent(sb, obj, context);
            }
        }
    }

    private void getObjectContentAsText(StringBuilder contentText, BaseObject baseObject, String property, XWikiContext context) {
        BaseProperty baseProperty = (BaseProperty)baseObject.getField(property);
        if (baseProperty != null && baseProperty.getValue() != null && !(baseObject.getXClass(context).getField(property) instanceof PasswordClass)) {
            contentText.append(StringUtils.lowerCase((String)baseProperty.getValue().toString()));
        }
    }

    private void extractObjectContent(StringBuilder contentText, BaseObject baseObject, XWikiContext context) {
        if (baseObject != null) {
            String[] propertyNames;
            for (String propertyName : propertyNames = baseObject.getPropertyNames()) {
                this.getObjectContentAsText(contentText, baseObject, propertyName, context);
                contentText.append(" ");
            }
        }
    }

    @Override
    public void addDocumentDataToLuceneDocument(Document luceneDoc, XWikiDocument doc, XWikiContext context) {
        super.addDocumentDataToLuceneDocument(luceneDoc, doc, context);
        for (List objects : doc.getXObjects().values()) {
            for (BaseObject obj : objects) {
                if (obj == null) continue;
                DocumentData.addFieldToDocument("object", ((String)this.localEntityReferenceSerializer.serialize((EntityReference)obj.getXClassReference(), new Object[0])).toLowerCase(), Field.Store.YES, Field.Index.NOT_ANALYZED, 0.5f, luceneDoc);
                String[] propertyNames = obj.getPropertyNames();
                for (int i = 0; i < propertyNames.length; ++i) {
                    this.indexProperty(luceneDoc, obj, propertyNames[i], context);
                }
            }
        }
    }

    private void indexProperty(Document luceneDoc, BaseObject baseObject, String propertyName, XWikiContext context) {
        String fieldFullName = baseObject.getClassName() + "." + propertyName;
        BaseClass bClass = baseObject.getXClass(context);
        PropertyInterface prop = bClass.getField(propertyName);
        if (!(prop instanceof PasswordClass)) {
            if (prop instanceof StaticListClass && ((StaticListClass)prop).isMultiSelect()) {
                this.indexStaticList(luceneDoc, baseObject, (StaticListClass)prop, propertyName, context);
            } else if (prop instanceof DateClass) {
                DocumentData.addFieldToDocument(fieldFullName, this.getContentAsDate(baseObject, propertyName), Field.Store.YES, Field.Index.NOT_ANALYZED, 0.75f, luceneDoc);
            } else {
                StringBuilder sb = new StringBuilder();
                this.getObjectContentAsText(sb, baseObject, propertyName, context);
                DocumentData.addFieldToDocument(fieldFullName, sb.toString(), Field.Store.YES, Field.Index.ANALYZED, 0.75f, luceneDoc);
            }
        }
    }

    private void indexStaticList(Document luceneDoc, BaseObject baseObject, StaticListClass prop, String propertyName, XWikiContext context) {
        Map possibleValues = prop.getMap(context);
        String fieldFullName = baseObject.getClassName() + "." + propertyName;
        for (String value : baseObject.getListValue(propertyName)) {
            ListItem item = (ListItem)possibleValues.get(value);
            if (item != null) {
                String fieldName = fieldFullName + ".key";
                DocumentData.addFieldToDocument(fieldName, item.getId(), Field.Store.YES, Field.Index.ANALYZED, 0.75f, luceneDoc);
                fieldName = fieldFullName + ".value";
                DocumentData.addFieldToDocument(fieldName, item.getValue(), Field.Store.YES, Field.Index.ANALYZED, 0.75f, luceneDoc);
                if (!item.getId().equals(item.getValue())) {
                    DocumentData.addFieldToDocument(fieldFullName, item.getValue(), Field.Store.YES, Field.Index.ANALYZED, 0.75f, luceneDoc);
                }
            }
            DocumentData.addFieldToDocument(fieldFullName, value, Field.Store.YES, Field.Index.ANALYZED, 0.75f, luceneDoc);
        }
    }

    private String getContentAsDate(BaseObject baseObject, String propertyName) {
        Date date = baseObject.getDateValue(propertyName);
        if (date != null) {
            return IndexFields.dateToString(date);
        }
        return "";
    }
}

