/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.lucene.internal.rest;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.XWiki;
import com.xpn.xwiki.plugin.lucene.LucenePlugin;
import com.xpn.xwiki.plugin.lucene.SearchResult;
import com.xpn.xwiki.plugin.lucene.SearchResults;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.internal.resources.search.AbstractSearchSource;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.resources.attachments.AttachmentResource;
import org.xwiki.rest.resources.pages.PageResource;
import org.xwiki.rest.resources.pages.PageTranslationResource;

@Component
@Named(value="lucene")
@Singleton
public class LuceneSearchSource
extends AbstractSearchSource {
    @Inject
    protected Provider<XWikiContext> xcontextProvider;

    public List<org.xwiki.rest.model.jaxb.SearchResult> search(String query, String defaultWikiName, String wikis, boolean hasProgrammingRights, String orderField, String order, boolean distinct, int number, int start, Boolean withPrettyNames, String className, UriInfo uriInfo) throws Exception {
        XWikiContext xwikiContext = (XWikiContext)this.xcontextProvider.get();
        XWiki xwikiApi = new XWiki(xwikiContext.getWiki(), xwikiContext);
        ArrayList<org.xwiki.rest.model.jaxb.SearchResult> result = new ArrayList<org.xwiki.rest.model.jaxb.SearchResult>();
        if (query == null) {
            return result;
        }
        if (defaultWikiName == null && wikis == null) {
            return result;
        }
        if (!hasProgrammingRights) {
            query = query + " AND NOT space:XWiki AND NOT space:Admin AND NOT space:Panels AND NOT name:WebPreferences";
        }
        try {
            LucenePlugin lucene = (LucenePlugin)xwikiContext.getWiki().getPlugin("lucene", xwikiContext);
            String orderParameter = "";
            if (!StringUtils.isBlank((CharSequence)orderField)) {
                orderParameter = "desc".equals(order) ? String.format("-%s", orderField) : orderField;
            }
            SearchResults luceneSearchResults = lucene.getSearchResults(query, orderParameter, wikis == null ? defaultWikiName : wikis, "", xwikiContext);
            List<SearchResult> luceneResults = luceneSearchResults.getResults(start + 1, number == -1 ? 20 : number);
            for (SearchResult luceneSearchResult : luceneResults) {
                String language;
                String wikiName = luceneSearchResult.getWiki();
                String spaceName = luceneSearchResult.getSpace();
                String pageName = luceneSearchResult.getName();
                String pageFullName = Utils.getPageFullName((String)wikiName, (String)spaceName, (String)pageName);
                String pageId = Utils.getPageId((String)wikiName, (String)spaceName, (String)pageName);
                if (!xwikiApi.hasAccessLevel("view", pageId)) continue;
                Document doc = xwikiApi.getDocument(pageId);
                String title = doc.getDisplayTitle();
                org.xwiki.rest.model.jaxb.SearchResult searchResult = this.objectFactory.createSearchResult();
                searchResult.setPageFullName(pageFullName);
                searchResult.setTitle(title);
                searchResult.setWiki(wikiName);
                searchResult.setSpace(spaceName);
                searchResult.setPageName(pageName);
                searchResult.setVersion(doc.getVersion());
                if (luceneSearchResult.getType().equals("wikipage")) {
                    searchResult.setType("page");
                    searchResult.setId(Utils.getPageId((String)wikiName, (String)spaceName, (String)pageName));
                } else {
                    searchResult.setType("file");
                    searchResult.setId(String.format("%s@%s", Utils.getPageId((String)wikiName, (String)pageFullName), luceneSearchResult.getFilename()));
                    searchResult.setFilename(luceneSearchResult.getFilename());
                    String attachmentUri = Utils.createURI((URI)uriInfo.getBaseUri(), AttachmentResource.class, (Object[])new Object[]{wikiName, spaceName, pageName, luceneSearchResult.getFilename()}).toString();
                    Link attachmentLink = new Link();
                    attachmentLink.setHref(attachmentUri);
                    attachmentLink.setRel("http://www.xwiki.org/rel/attachmentData");
                    searchResult.getLinks().add(attachmentLink);
                }
                searchResult.setScore(Float.valueOf(luceneSearchResult.getScore()));
                searchResult.setAuthor(luceneSearchResult.getAuthor());
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(doc.getDate());
                searchResult.setModified(calendar);
                if (withPrettyNames.booleanValue()) {
                    searchResult.setAuthorName(xwikiApi.getUserName(luceneSearchResult.getAuthor(), false));
                }
                if ((language = luceneSearchResult.getLanguage()).equals("default")) {
                    language = "";
                }
                String pageUri = null;
                if (StringUtils.isBlank((CharSequence)language)) {
                    pageUri = Utils.createURI((URI)uriInfo.getBaseUri(), PageResource.class, (Object[])new Object[]{wikiName, spaceName, pageName}).toString();
                } else {
                    searchResult.setLanguage(language);
                    pageUri = Utils.createURI((URI)uriInfo.getBaseUri(), PageTranslationResource.class, (Object[])new Object[]{wikiName, spaceName, pageName, language}).toString();
                }
                Link pageLink = new Link();
                pageLink.setHref(pageUri);
                pageLink.setRel("http://www.xwiki.org/rel/page");
                searchResult.getLinks().add(pageLink);
                result.add(searchResult);
            }
        }
        catch (Exception e) {
            throw new XWikiException(0, 0, "Error performing lucene search", (Throwable)e);
        }
        return result;
    }
}

