/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.lucene;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.api.Context;
import com.xpn.xwiki.api.XWiki;
import com.xpn.xwiki.plugin.PluginApi;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.lucene.LucenePlugin;
import com.xpn.xwiki.plugin.lucene.SearchResults;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LucenePluginApi
extends PluginApi<LucenePlugin> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LucenePluginApi.class);
    public static final int REBUILD_NOT_ALLOWED = -1;
    public static final int REBUILD_IN_PROGRESS = -2;

    public LucenePluginApi(LucenePlugin plugin, XWikiContext context) {
        super((XWikiPluginInterface)plugin, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rebuildIndex() {
        if (this.hasAdminRights()) {
            List<String> wikis = null;
            String database = this.context.getWikiId();
            try {
                this.context.setWikiId(this.context.getMainXWiki());
                if (!this.hasAdminRights()) {
                    wikis = Collections.singletonList(database);
                }
            }
            finally {
                this.context.setWikiId(database);
            }
            return ((LucenePlugin)this.getProtectedPlugin()).startIndex(wikis, "", true, false, this.context);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startIndex(Collection<String> wikis, String hqlFilter, boolean clearIndex, boolean onlyNew) {
        if (this.hasAdminRights()) {
            Collection<String> secureWikis = wikis;
            String currentWiki = this.context.getWikiId();
            try {
                this.context.setWikiId(this.context.getMainXWiki());
                if (!this.hasAdminRights()) {
                    secureWikis = Collections.singletonList(currentWiki);
                }
            }
            finally {
                this.context.setWikiId(currentWiki);
            }
            String secureHqlFilter = this.hasProgrammingRights() ? hqlFilter : null;
            return ((LucenePlugin)this.getProtectedPlugin()).startIndex(secureWikis, secureHqlFilter, clearIndex, onlyNew, this.context);
        }
        return -1;
    }

    @Deprecated
    public int rebuildIndex(XWiki wiki, Context context) {
        if (wiki.hasAdminRights()) {
            return ((LucenePlugin)this.getProtectedPlugin()).rebuildIndex(context.getContext());
        }
        return -1;
    }

    public long getQueueSize() {
        try {
            return ((LucenePlugin)this.getProtectedPlugin()).getQueueSize();
        }
        catch (Exception e) {
            LOGGER.error("Failed to get the remaining number of documents to index in the queue", (Throwable)e);
            return 0L;
        }
    }

    public long getLuceneDocCount() {
        try {
            return ((LucenePlugin)this.getProtectedPlugin()).getLuceneDocCount();
        }
        catch (Exception e) {
            LOGGER.error("Failed to get the number of documents Lucene index writer", (Throwable)e);
            return 0L;
        }
    }

    public SearchResults getSearchResultsFromIndexes(String query, String indexDirs, String languages) {
        try {
            return ((LucenePlugin)this.getProtectedPlugin()).getSearchResults(query, (String)null, indexDirs, languages, this.context);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to search: query=[{}], indexDirs=[{}], languages=[{}]", new Object[]{query, indexDirs, languages, ex});
            return null;
        }
    }

    public SearchResults getSearchResults(String query, String languages) {
        return this.getSearchResultsFromIndexes(query, null, languages);
    }

    public SearchResults getSearchResultsFromIndexes(String query, String sortField, String indexDirs, String languages) {
        try {
            return ((LucenePlugin)this.getProtectedPlugin()).getSearchResults(query, sortField, indexDirs, languages, this.context);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to search: query=[{}], sortField=[{}], indexDirs=[{}], languages=[{}]", new Object[]{query, sortField, indexDirs, languages, ex});
            return null;
        }
    }

    public SearchResults getSearchResultsFromIndexes(String query, String[] sortField, String indexDirs, String languages) {
        try {
            return ((LucenePlugin)this.getProtectedPlugin()).getSearchResults(query, sortField, indexDirs, languages, this.context);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to search: query=[{}], sortField=[{}], indexDirs=[{}], languages=[{}]", new Object[]{query, sortField, indexDirs, languages, ex});
            return null;
        }
    }

    public SearchResults getSearchResults(String query, String sortField, String languages) {
        return this.getSearchResultsFromIndexes(query, sortField, null, languages);
    }

    public SearchResults getSearchResults(String query, String sortField, String virtualWikiNames, String languages) {
        try {
            SearchResults retval = ((LucenePlugin)this.getProtectedPlugin()).getSearchResults(query, sortField, virtualWikiNames, languages, this.context);
            LOGGER.debug("returning {} results", (Object)retval.getHitcount());
            return retval;
        }
        catch (Exception ex) {
            LOGGER.error("Failed to search: query=[{}], sortField=[{}], languages=[{}]", new Object[]{query, sortField, languages, ex});
            return null;
        }
    }

    public SearchResults getSearchResults(String query, String[] sortField, String languages) {
        return this.getSearchResultsFromIndexes(query, sortField, null, languages);
    }

    public SearchResults getSearchResults(String query, String[] sortField, String virtualWikiNames, String languages) {
        try {
            SearchResults retval = ((LucenePlugin)this.getProtectedPlugin()).getSearchResults(query, sortField, virtualWikiNames, languages, this.context);
            LOGGER.debug("returning {} results", (Object)retval.getHitcount());
            return retval;
        }
        catch (Exception ex) {
            LOGGER.error("Failed to search: query=[{}], sortField=[{}], virtualWikiNames=[{}], languages=[{}]", new Object[]{query, sortField, virtualWikiNames, languages, ex});
            return null;
        }
    }
}

