/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.lucene;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.plugin.lucene.AbstractDocumentData;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.tika.Tika;
import org.apache.tika.metadata.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentData
extends AbstractDocumentData {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentData.class);
    private static final float ATTACHMENT_GLOBAL_BOOST = 0.25f;
    private static final float FILENAME_BOOST = 3.0f;
    private static final float IRRELEVANT_DOCUMENT_FIELD_BOOST = 0.1f;
    private static final List<String> RELEVANT_DOCUMENT_FIELDS = new ArrayList<String>();
    private int size;
    private String filename;

    public AttachmentData(XWikiAttachment attachment, XWikiContext context, boolean deleted) {
        super("attachment", attachment.getDoc(), context, deleted);
        this.setModificationDate(attachment.getDate());
        this.setAuthor(attachment.getAuthor());
        this.setSize(attachment.getFilesize());
        this.setFilename(attachment.getFilename());
    }

    public AttachmentData(XWikiDocument document, String filename, XWikiContext context, boolean deleted) {
        super("attachment", document, context, deleted);
        this.setFilename(filename);
    }

    @Override
    public void addDataToLuceneDocument(Document luceneDoc, XWikiContext context) throws XWikiException {
        super.addDataToLuceneDocument(luceneDoc, context);
        List existingFields = luceneDoc.getFields();
        for (Fieldable f : existingFields) {
            if (RELEVANT_DOCUMENT_FIELDS.contains(f.name())) continue;
            f.setBoost(f.getBoost() * 0.1f);
        }
        if (this.filename != null) {
            AttachmentData.addFieldToDocument("filename", this.filename, Field.Store.YES, Field.Index.ANALYZED, 3.0f, luceneDoc);
        }
        luceneDoc.setBoost(0.25f);
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public String getId() {
        return new StringBuffer(super.getId()).append(".file.").append(this.filename).toString();
    }

    @Override
    protected void getFullText(StringBuilder sb, XWikiDocument doc, XWikiContext context) {
        super.getFullText(sb, doc, context);
        String contentText = this.getContentAsText(doc, context);
        if (contentText != null) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(contentText);
        }
    }

    private String getContentAsText(XWikiDocument doc, XWikiContext context) {
        String contentText = null;
        try {
            XWikiAttachment att = doc.getAttachment(this.filename);
            LOGGER.debug("Start parsing attachement [{}] in document [{}]", (Object)this.filename, (Object)doc.getDocumentReference());
            Tika tika = new Tika();
            Metadata metadata = new Metadata();
            metadata.set("resourceName", this.filename);
            contentText = StringUtils.lowerCase((String)tika.parseToString(att.getContentInputStream(context), metadata));
        }
        catch (Throwable ex) {
            LOGGER.warn("error getting content of attachment [{}] for document [{}]", new Object[]{this.filename, doc.getDocumentReference(), ex});
        }
        return contentText;
    }

    static {
        RELEVANT_DOCUMENT_FIELDS.add("_docid");
        RELEVANT_DOCUMENT_FIELDS.add("type");
        RELEVANT_DOCUMENT_FIELDS.add("author");
        RELEVANT_DOCUMENT_FIELDS.add("ft");
    }
}

