/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.lucene;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.api.XWiki;
import com.xpn.xwiki.plugin.lucene.SearchResult;
import com.xpn.xwiki.web.Utils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

public class SearchResults
extends Api {
    private final XWiki xwiki;
    private final IndexSearcher searcher;
    private final TopDocsCollector<? extends ScoreDoc> results;
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchResults.class);
    private List<SearchResult> relevantResults;

    public SearchResults(TopDocsCollector<? extends ScoreDoc> results, IndexSearcher searcher, XWiki xwiki, XWikiContext context) {
        super(context);
        this.results = results;
        this.searcher = searcher;
        this.xwiki = xwiki;
    }

    private List<SearchResult> getRelevantResults() {
        if (this.relevantResults == null) {
            this.relevantResults = new ArrayList<SearchResult>();
            TopDocs docs = this.results.topDocs();
            for (int i = 0; i < docs.scoreDocs.length; ++i) {
                try {
                    SearchResult result = new SearchResult(this.searcher.doc(docs.scoreDocs[i].doc), docs.scoreDocs[i].score, this.xwiki);
                    if (!result.isWikiContent()) continue;
                    String prefixedFullName = (String)((EntityReferenceSerializer)Utils.getComponent((Type)EntityReferenceSerializer.TYPE_STRING)).serialize((EntityReference)result.getDocumentReference(), new Object[0]);
                    if (!this.xwiki.exists(result.getDocumentReference()) || !this.xwiki.hasAccessLevel("view", this.context.getUser(), prefixedFullName)) continue;
                    this.relevantResults.add(result);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("Error getting search result", (Throwable)e);
                }
            }
        }
        return this.relevantResults;
    }

    public boolean hasNext(String beginIndex, String items) {
        int itemCount = Integer.parseInt(items);
        int begin = Integer.parseInt(beginIndex);
        return begin + itemCount - 1 < this.getRelevantResults().size();
    }

    public boolean hasPrevious(String beginIndex) {
        return Integer.parseInt(beginIndex) > 1;
    }

    public int getNextIndex(String beginIndex, String items) {
        int itemCount = Integer.parseInt(items);
        int resultcount = this.getRelevantResults().size();
        int retval = Integer.parseInt(beginIndex) + itemCount;
        return retval > resultcount ? resultcount - itemCount + 1 : retval;
    }

    public int getPreviousIndex(String beginIndex, String items) {
        int retval = Integer.parseInt(beginIndex) - Integer.parseInt(items);
        return 0 < retval ? retval : 1;
    }

    public int getEndIndex(String beginIndex, String items) {
        int resultcount;
        int retval = Integer.parseInt(beginIndex) + Integer.parseInt(items) - 1;
        if (retval > (resultcount = this.getRelevantResults().size())) {
            return resultcount;
        }
        return retval;
    }

    public List<SearchResult> getResults(String beginIndex, String items) {
        return this.getResults(Integer.parseInt(beginIndex), Integer.parseInt(items));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<SearchResult> getResults(int beginIndex, int items) {
        int n;
        int listStartIndex = beginIndex - 1;
        int listEndIndex = listStartIndex + items;
        int resultcount = 0;
        List<SearchResult> relResults = this.relevantResults;
        if (relResults == null) {
            relResults = new ArrayList<SearchResult>();
            TopDocs docs = this.results.topDocs();
            String database = this.context.getDatabase();
            try {
                int i = 0;
                while (i < docs.scoreDocs.length) {
                    SearchResult result = null;
                    try {
                        result = new SearchResult(this.searcher.doc(docs.scoreDocs[i].doc), docs.scoreDocs[i].score, this.xwiki);
                        this.context.setDatabase(result.getWiki());
                        String pageName = null;
                        if (result.isWikiContent()) {
                            pageName = result.getWiki() + ":" + result.getSpace() + "." + result.getName();
                        }
                        if (result.isWikiContent() && this.xwiki.exists(pageName) && this.xwiki.checkAccess(pageName, "view")) {
                            if (resultcount >= listStartIndex) {
                                relResults.add(result);
                            }
                            if (++resultcount == listEndIndex) {
                                List<SearchResult> list = relResults;
                                return list;
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("error getting search result", (Throwable)e);
                    }
                    ++i;
                }
                return relResults;
            }
            finally {
                this.context.setDatabase(database);
            }
        }
        resultcount = this.getRelevantResults().size();
        List<SearchResult> list = this.getRelevantResults();
        if (listEndIndex < resultcount) {
            n = listEndIndex;
            return list.subList(listStartIndex, n);
        }
        n = resultcount;
        return list.subList(listStartIndex, n);
    }

    public List<SearchResult> getResults() {
        return this.getRelevantResults();
    }

    public int getHitcount() {
        return this.getRelevantResults().size();
    }

    public int getTotalHitcount() {
        return this.results.getTotalHits();
    }
}

