/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.search.solr.internal.job;

import org.xwiki.job.AbstractRequest;
import org.xwiki.job.Request;
import org.xwiki.model.reference.EntityReference;

/**
 * The request used to configure {@link IndexerJob}.
 * 
 * @version $Id: 893e60ba9225f160da7b8539ebb27205706e988a $
 * @since 5.1RC1
 */
public class IndexerRequest extends AbstractRequest
{
    /**
     * Serialization identifier.
     */
    private static final long serialVersionUID = 1L;

    /**
     * @see #getRootReference()
     */
    private EntityReference rootReference;

    /**
     * @see #isOverwrite()
     */
    private boolean overwrite;

    /**
     * @see #isRemoveMissing()
     */
    private boolean removeMissing = true;

    /**
     * The default constructor.
     */
    public IndexerRequest()
    {
    }

    /**
     * @param request the request to copy
     */
    public IndexerRequest(Request request)
    {
        super(request);
    }

    /**
     * @return the reference from which to work
     */
    public EntityReference getRootReference()
    {
        return this.rootReference;
    }

    /**
     * @param rootReference the reference from which to work
     */
    public void setRootReference(EntityReference rootReference)
    {
        this.rootReference = rootReference;
    }

    /**
     * @return if false documents are indexed only if they don't already exist in Solr index (version is taken into
     *         account), if true all documents are sent and overwrite what's already in Solr if any
     */
    public boolean isOverwrite()
    {
        return this.overwrite;
    }

    /**
     * @param overwrite if false documents are indexed only if they don't already exist in Solr index (version is taken
     *            into account), if true all documents are sent and overwrite what's already in Solr if any
     */
    public void setOverwrite(boolean overwrite)
    {
        this.overwrite = overwrite;
    }

    /**
     * @return if true the Solr document not in database anymore are cleaned, if false nothing is checked
     */
    public boolean isRemoveMissing()
    {
        return this.removeMissing;
    }

    /**
     * @param removeMissing if true the Solr document not in database anymore are cleaned, if false nothing is checked
     */
    public void setRemoveMissing(boolean removeMissing)
    {
        this.removeMissing = removeMissing;
    }
}
