/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.lucene.util.Version;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.environment.Environment;
import org.xwiki.search.solr.internal.AbstractSolrInstance;
import org.xwiki.search.solr.internal.api.SolrConfiguration;

@Component
@Named(value="embedded")
@Singleton
public class EmbeddedSolrInstance
extends AbstractSolrInstance
implements Disposable {
    public static final String TYPE = "embedded";
    public static final String DEFAULT_SOLR_DIRECTORY_NAME = "solr";
    @Inject
    private SolrConfiguration solrConfiguration;
    @Inject
    private Environment environment;
    private CoreContainer container;

    public void initialize() throws InitializationException {
        String solrHome = this.determineHomeDirectory();
        try {
            this.validateAndInitializeHomeDirectory(solrHome);
            this.logger.info("Starting embedded Solr server...");
            this.logger.info("Using Solr home directory: [{}]", (Object)solrHome);
            this.container = this.createCoreContainer(solrHome);
            String coreName = ((SolrCore)this.container.getCores().iterator().next()).getName();
            this.server = new EmbeddedSolrServer(this.container, coreName);
            this.logger.info("Started embedded Solr server.");
        }
        catch (Exception e) {
            throw new InitializationException(String.format("Failed to initialize the Solr embedded server with home directory set to [%s]", solrHome), (Throwable)e);
        }
    }

    private CoreContainer createCoreContainer(String solrHome) throws SolrServerException {
        CoreContainer coreContainer = new CoreContainer(solrHome);
        coreContainer.load();
        if (coreContainer.getCores().isEmpty()) {
            throw new SolrServerException("Failed to initialize the Solr core. Please check the configuration and log messages.");
        }
        if (coreContainer.getCores().size() > 1) {
            this.logger.warn("Multiple Solr cores detected: [{}]. Using the first one.", (Object)coreContainer.getAllCoreNames());
        }
        return coreContainer;
    }

    public void dispose() {
        if (this.server != null) {
            try {
                this.server.close();
            }
            catch (IOException e) {
                this.logger.error("Failed to close server", (Throwable)e);
            }
        }
        if (this.container != null) {
            this.container.shutdown();
        }
    }

    protected CoreContainer getContainer() {
        return this.container;
    }

    private void validateAndInitializeHomeDirectory(String solrHome) throws IllegalArgumentException, IOException {
        File solrHomeDirectory = new File(solrHome);
        if (solrHomeDirectory.exists()) {
            if (!this.isValid(solrHomeDirectory)) {
                this.recreateHomeDirectory(solrHomeDirectory);
            }
        } else {
            this.createHomeDirectory(solrHomeDirectory);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isExpectedSolrVersion(File solrconfigFile) {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        try (FileReader reader = new FileReader(solrconfigFile);){
            XMLStreamReader xmlReader = factory.createXMLStreamReader(reader);
            xmlReader.nextTag();
            while (xmlReader.isStartElement()) {
                if (xmlReader.getLocalName().equals("luceneMatchVersion")) {
                    String versionStr = xmlReader.getElementText();
                    boolean bl = Version.LATEST.toString().equals(versionStr);
                    return bl;
                }
                xmlReader.nextTag();
            }
            return false;
        }
        catch (Exception e) {
            this.logger.warn("Failed to parse Solr configuration at [{}]: {}", (Object)solrconfigFile, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        return false;
    }

    private boolean isValid(File solrHomeDirectory) {
        if (!(solrHomeDirectory.isDirectory() && solrHomeDirectory.canWrite() && solrHomeDirectory.canRead())) {
            throw new IllegalArgumentException(String.format("The given path [%s] must be a readable and writable directory", solrHomeDirectory));
        }
        File solrconfigFile = new File(solrHomeDirectory, "xwiki/conf/solrconfig.xml");
        return solrconfigFile.exists() && this.isExpectedSolrVersion(solrconfigFile);
    }

    private void recreateHomeDirectory(File solrHomeDirectory) throws IOException {
        if (solrHomeDirectory.exists()) {
            File newDirectory = this.archiveHomeDirectory(solrHomeDirectory);
            this.logger.warn("The Solr home directory at [{}] is invalid. Archiving it at [{}] and creating a new one.", (Object)solrHomeDirectory, (Object)newDirectory);
        }
        this.createHomeDirectory(solrHomeDirectory);
    }

    private File archiveHomeDirectory(File solrHomeDirectory) throws IOException {
        File archiveDirectory = solrHomeDirectory.getParentFile();
        archiveDirectory = new File(archiveDirectory, solrHomeDirectory.getName() + "-" + new Date().getTime());
        FileUtils.moveDirectoryToDirectory((File)solrHomeDirectory, (File)archiveDirectory, (boolean)true);
        return archiveDirectory;
    }

    private void createHomeDirectory(File solrHomeDirectory) throws IOException {
        if (!solrHomeDirectory.mkdirs()) {
            throw new IllegalArgumentException(String.format("The given path [%s] could not be created due to an invalid value or to insufficient filesystem permissions", solrHomeDirectory));
        }
        this.logger.info("Generating a new Solr home directory at [{}]", (Object)solrHomeDirectory);
        InputStream stream = this.solrConfiguration.getHomeDirectoryConfiguration();
        try (ZipInputStream zstream = new ZipInputStream(stream);){
            ZipEntry entry = zstream.getNextEntry();
            while (entry != null) {
                if (entry.isDirectory()) {
                    File destinationDirectory = new File(solrHomeDirectory, entry.getName());
                    destinationDirectory.mkdirs();
                } else {
                    File destinationFile = new File(solrHomeDirectory, entry.getName());
                    FileUtils.copyInputStreamToFile((InputStream)new CloseShieldInputStream((InputStream)zstream), (File)destinationFile);
                }
                entry = zstream.getNextEntry();
            }
        }
    }

    private String determineHomeDirectory() {
        String defaultValue = this.getDefaultHomeDirectory();
        return this.solrConfiguration.getInstanceConfiguration(TYPE, "home", defaultValue);
    }

    String getDefaultHomeDirectory() {
        return new File(this.environment.getPermanentDirectory(), DEFAULT_SOLR_DIRECTORY_NAME).getPath();
    }
}

