/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.slf4j.Logger;
import org.xwiki.search.solr.internal.api.SolrInstance;

public abstract class AbstractSolrInstance
implements SolrInstance {
    protected CoreContainer container;
    protected SolrServer server;
    @Inject
    protected Logger logger;

    @Override
    public void add(SolrInputDocument solrDocument) throws SolrServerException, IOException {
        this.server.add(solrDocument);
    }

    @Override
    public void add(List<SolrInputDocument> solrDocuments) throws SolrServerException, IOException {
        this.server.add(solrDocuments);
    }

    @Override
    public void delete(String id) throws SolrServerException, IOException {
        this.server.deleteById(id);
    }

    @Override
    public void delete(List<String> ids) throws SolrServerException, IOException {
        this.server.deleteById(ids);
    }

    @Override
    public void deleteByQuery(String query) throws SolrServerException, IOException {
        this.server.deleteByQuery(query);
    }

    @Override
    public void commit() throws SolrServerException, IOException {
        this.server.commit();
    }

    @Override
    public void rollback() throws SolrServerException, IOException {
        this.server.rollback();
    }

    @Override
    public QueryResponse query(SolrParams solrParams) throws SolrServerException {
        QueryResponse result = this.server.query(solrParams);
        return result;
    }

    protected CoreContainer getContainer() {
        return this.container;
    }

    protected SolrServer getServer() {
        return this.server;
    }
}

