/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.search.solr.internal.api.SolrInstance;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.SINGLETON)
public class SolrInstanceProvider
implements Provider<SolrInstance> {
    public static final String DEFAULT_SOLR_TYPE = "embedded";
    @Inject
    private ConfigurationSource configuration;
    @Inject
    private Logger logger;
    @Inject
    private ComponentManager componentManager;

    public SolrInstance get() {
        String type = this.getType();
        SolrInstance newInstance = null;
        try {
            newInstance = (SolrInstance)this.componentManager.getInstance(SolrInstance.class, type);
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to lookup Solr instance", (Throwable)e);
        }
        return newInstance;
    }

    String getType() {
        return DEFAULT_SOLR_TYPE;
    }
}

