/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseObjectReference;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.classes.PasswordClass;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.ObjectPropertyReference;
import org.xwiki.model.reference.ObjectReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.query.QueryManager;
import org.xwiki.search.solr.internal.IndexableReferenceExtractor;
import org.xwiki.search.solr.internal.api.SolrIndexException;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.SINGLETON)
public class DefaultIndexableReferenceExtractor
implements IndexableReferenceExtractor {
    @Inject
    protected EntityReferenceSerializer<String> serializer;
    @Inject
    protected Execution execution;
    @Inject
    protected DocumentAccessBridge documentAccessBridge;
    @Inject
    protected QueryManager queryManager;

    @Override
    public List<EntityReference> getReferences(EntityReference startReference) throws SolrIndexException {
        ArrayList<EntityReference> references = new ArrayList<EntityReference>();
        try {
            switch (startReference.getType()) {
                case WIKI: {
                    WikiReference wikiReference = new WikiReference(startReference);
                    references.addAll(this.getReferencesFor(wikiReference));
                    break;
                }
                case SPACE: {
                    SpaceReference spaceReference = new SpaceReference(startReference);
                    references.addAll(this.getReferencesFor(spaceReference));
                    break;
                }
                case DOCUMENT: {
                    DocumentReference documentReference = new DocumentReference(startReference);
                    references.addAll(this.getReferencesFor(documentReference));
                    break;
                }
                case OBJECT: {
                    BaseObjectReference objectReference = new BaseObjectReference(startReference);
                    references.addAll(this.getReferencesFor(objectReference));
                    break;
                }
                case OBJECT_PROPERTY: {
                    ObjectPropertyReference objectPropertyReference = new ObjectPropertyReference(startReference);
                    references.addAll(this.getReferencesFor(objectPropertyReference));
                    break;
                }
                case ATTACHMENT: {
                    AttachmentReference attachmentReference = new AttachmentReference(startReference);
                    references.add((EntityReference)attachmentReference);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new SolrIndexException(String.format("Failed to compute the list of entities to index for '%s'", this.serializer.serialize(startReference, new Object[0])), e);
        }
        return references;
    }

    protected List<EntityReference> getReferencesFor(ObjectPropertyReference objectPropertyReference) throws Exception {
        ArrayList<EntityReference> result = new ArrayList<EntityReference>();
        BaseObjectReference objectReference = new BaseObjectReference(objectPropertyReference.getParent());
        DocumentReference classReference = objectReference.getXClassReference();
        if (!(this.getDocument(classReference).getXClass().get(objectPropertyReference.getName()) instanceof PasswordClass)) {
            result.add((EntityReference)objectPropertyReference);
        }
        return result;
    }

    protected List<EntityReference> getReferencesFor(BaseObjectReference objectReference) throws Exception {
        ArrayList<EntityReference> result = new ArrayList<EntityReference>();
        result.add((EntityReference)objectReference);
        DocumentReference documentReference = new DocumentReference(objectReference.getParent());
        XWikiDocument document = this.getDocument(documentReference);
        BaseObject object = document.getXObject((ObjectReference)objectReference);
        if (object != null) {
            for (Object field : object.getFieldList()) {
                BaseProperty objectProperty = (BaseProperty)field;
                result.addAll(this.getReferences(objectProperty.getReference()));
            }
        }
        return result;
    }

    protected List<EntityReference> getReferencesFor(DocumentReference documentReference) throws Exception {
        ArrayList<EntityReference> result = new ArrayList<EntityReference>();
        XWikiContext context = this.getXWikiContext();
        if (this.documentAccessBridge.exists(documentReference)) {
            result.add((EntityReference)documentReference);
            if (documentReference.getLocale() == null) {
                XWikiDocument document = this.getDocument(documentReference);
                List translatedLanguages = document.getTranslationList(context);
                for (String translatedLanguage : translatedLanguages) {
                    DocumentReference translatedDocumentReference = new DocumentReference((EntityReference)documentReference, new Locale(translatedLanguage));
                    result.add((EntityReference)translatedDocumentReference);
                }
                List attachmentReferences = this.documentAccessBridge.getAttachmentReferences(documentReference);
                result.addAll(attachmentReferences);
                for (Map.Entry entry : document.getXObjects().entrySet()) {
                    List objects = (List)entry.getValue();
                    for (BaseObject object : objects) {
                        if (object == null) continue;
                        result.addAll(this.getReferences(object.getReference()));
                    }
                }
            }
        }
        return result;
    }

    protected List<EntityReference> getReferencesFor(SpaceReference spaceReference) throws Exception {
        ArrayList<EntityReference> result = new ArrayList<EntityReference>();
        List documentNames = null;
        documentNames = this.queryManager.getNamedQuery("getSpaceDocsName").setWiki(spaceReference.getParent().getName()).bindValue("space", (Object)spaceReference.getName()).execute();
        for (String documentName : documentNames) {
            DocumentReference documentReference = new DocumentReference(documentName, spaceReference);
            result.addAll(this.getReferences((EntityReference)documentReference));
        }
        return result;
    }

    private List<EntityReference> getReferencesFor(WikiReference wikiReference) throws Exception {
        ArrayList<EntityReference> result = new ArrayList<EntityReference>();
        List spaces = null;
        spaces = this.queryManager.getNamedQuery("getSpaces").setWiki(wikiReference.getName()).execute();
        for (String space : spaces) {
            SpaceReference spaceReference = new SpaceReference(space, wikiReference);
            result.addAll(this.getReferences((EntityReference)spaceReference));
        }
        return result;
    }

    protected XWikiContext getXWikiContext() {
        ExecutionContext executionContext = this.execution.getContext();
        XWikiContext context = (XWikiContext)executionContext.getProperty("xwikicontext");
        return context;
    }

    protected XWikiDocument getDocument(DocumentReference documentReference) throws Exception {
        XWikiContext context = this.getXWikiContext();
        XWikiDocument document = context.getWiki().getDocument(documentReference, context);
        return document;
    }
}

