/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal.metadata;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObjectReference;
import com.xpn.xwiki.objects.BaseProperty;
import java.util.List;
import javax.inject.Named;
import org.apache.solr.common.SolrInputDocument;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.ObjectPropertyReference;
import org.xwiki.search.solr.internal.api.SolrIndexException;
import org.xwiki.search.solr.internal.metadata.AbstractSolrMetadataExtractor;

@Component
@Named(value="object_property")
public class ObjectPropertySolrMetadataExtractor
extends AbstractSolrMetadataExtractor {
    @Override
    public SolrInputDocument getSolrDocument(EntityReference entityReference) throws SolrIndexException, IllegalArgumentException {
        ObjectPropertyReference objectPropertyReference = new ObjectPropertyReference(entityReference);
        try {
            SolrInputDocument solrDocument = new SolrInputDocument();
            BaseObjectReference objectReference = new BaseObjectReference(objectPropertyReference.getParent());
            DocumentReference classReference = objectReference.getXClassReference();
            DocumentReference documentReference = new DocumentReference(objectReference.getParent());
            XWikiDocument document = this.getDocument(documentReference);
            BaseProperty objectProperty = document.getXObjectProperty(objectPropertyReference);
            solrDocument.addField("id", (Object)this.getId((EntityReference)objectPropertyReference));
            this.addDocumentFields(documentReference, solrDocument);
            solrDocument.addField("type", (Object)objectPropertyReference.getType().name());
            solrDocument.addField("class", this.localSerializer.serialize((EntityReference)classReference, new Object[0]));
            solrDocument.addField("propertyname", (Object)objectProperty.getName());
            this.addLanguageAndContentFields(documentReference, solrDocument, (BaseProperty<ObjectPropertyReference>)objectProperty);
            return solrDocument;
        }
        catch (Exception e) {
            throw new SolrIndexException(String.format("Failed to get Solr document for '%s'", this.serializer.serialize((EntityReference)objectPropertyReference, new Object[0])), e);
        }
    }

    protected void addLanguageAndContentFields(DocumentReference documentReference, SolrInputDocument solrDocument, BaseProperty<ObjectPropertyReference> objectProperty) throws Exception {
        String originalDocumentLanguage;
        XWikiDocument originalDocument = this.getDocument(documentReference);
        List documentLanguages = originalDocument.getTranslationList(this.getXWikiContext());
        if (!documentLanguages.contains(originalDocumentLanguage = this.getLanguage(documentReference))) {
            documentLanguages.add(originalDocumentLanguage);
        }
        for (String documentLanguage : documentLanguages) {
            if (!documentLanguage.equals(originalDocumentLanguage)) {
                solrDocument.addField("lang", (Object)documentLanguage);
            }
            solrDocument.addField(String.format("%s_%s", "propertyvalue", documentLanguage), objectProperty.getValue());
        }
        solrDocument.addField(String.format("%s_%s", "propertyvalue", "ml"), objectProperty.getValue());
    }
}

