/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.search.solr.internal.api.SolrConfiguration;

@Component
@Singleton
public class DefaultSolrConfiguration
implements SolrConfiguration {
    public static final String DEFAULT_SOLR_TYPE = "embedded";
    public static final String CLASSPATH_LOCATION_PREFIX = "/solr/%s";
    public static final String CONF_DIRECTORY = "conf";
    public static final String CONF_FILE_LOCATION_PATTERN = "/%s/%s/%s";
    public static final String[] HOME_DIRECTORY_FILE_NAMES = new String[]{"solr.xml"};
    public static final String HOME_DIRECTORY_CORE_PACKAGE = "solr.xwiki";
    public static final String HOME_DIRECTORY_PREFIX = "solr/";
    public static final String SOLR_INDEXER_BATCH_SIZE_PROPERTY = "solr.indexer.batch.size";
    public static final int SOLR_INDEXER_BATCH_SIZE_DEFAULT = 50;
    public static final String SOLR_INDEXER_BATCH_MAXLENGH_PROPERTY = "solr.indexer.batch.maxLength";
    public static final int SOLR_INDEXER_BATCH_MAXLENGH_DEFAULT = 10000;
    public static final String SOLR_INDEXER_QUEUE_CAPACITY_PROPERTY = "solr.indexer.queue.capacity";
    public static final int SOLR_INDEXER_QUEUE_CAPACITY_DEFAULT = 100000;
    public static final String SOLR_SYNCHRONIZE_AT_STARTUP = "solr.synchronizeAtStartup";
    public static final boolean SOLR_SYNCHRONIZE_AT_STARTUP_DEFAULT = true;
    @Inject
    @Named(value="xwikiproperties")
    private ConfigurationSource configuration;

    @Override
    public String getServerType() {
        return (String)this.configuration.getProperty("solr.type", (Object)DEFAULT_SOLR_TYPE);
    }

    @Override
    public <T> T getInstanceConfiguration(String instanceType, String propertyName, T defaultValue) {
        String actualPropertyName = String.format("%s.%s.%s", "solr", instanceType, propertyName);
        return (T)this.configuration.getProperty(actualPropertyName, defaultValue);
    }

    @Override
    public Map<String, URL> getHomeDirectoryConfiguration() {
        HashMap<String, URL> result = new HashMap<String, URL>();
        for (String file : HOME_DIRECTORY_FILE_NAMES) {
            result.put(file, this.getClass().getResource(String.format(CLASSPATH_LOCATION_PREFIX, file)));
        }
        Collection solrCoreResourcess = ClasspathHelper.forPackage((String)HOME_DIRECTORY_CORE_PACKAGE, (ClassLoader[])new ClassLoader[0]);
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setScanners(new Scanner[]{new ResourcesScanner()}).setUrls(solrCoreResourcess).filterInputsBy((Predicate)new FilterBuilder.Include(FilterBuilder.prefix((String)HOME_DIRECTORY_CORE_PACKAGE))));
        for (String resource : reflections.getResources(Predicates.alwaysTrue())) {
            URL resourceURL = this.getClass().getResource("/" + resource);
            if (resourceURL == null) continue;
            result.put(resource.substring(HOME_DIRECTORY_PREFIX.length()), resourceURL);
        }
        return result;
    }

    @Override
    public int getIndexerBatchSize() {
        return (Integer)this.configuration.getProperty(SOLR_INDEXER_BATCH_SIZE_PROPERTY, (Object)50);
    }

    @Override
    public int getIndexerBatchMaxLengh() {
        return (Integer)this.configuration.getProperty(SOLR_INDEXER_BATCH_MAXLENGH_PROPERTY, (Object)10000);
    }

    @Override
    public int getIndexerQueueCapacity() {
        return (Integer)this.configuration.getProperty(SOLR_INDEXER_QUEUE_CAPACITY_PROPERTY, (Object)100000);
    }

    @Override
    public boolean synchronizeAtStartup() {
        return (Boolean)this.configuration.getProperty(SOLR_SYNCHRONIZE_AT_STARTUP, (Object)true);
    }
}

