/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceValueProvider;

@Component
@Named(value="solr")
@Singleton
public class SolrFieldStringEntityReferenceResolver
implements EntityReferenceResolver<String> {
    static final char SEPARATOR = '.';
    private static final Map<EntityType, EntityType[]> ENTITY_TYPES = new HashMap<EntityType, EntityType[]>(){
        {
            this.put(EntityType.DOCUMENT, new EntityType[]{EntityType.DOCUMENT, EntityType.SPACE, EntityType.WIKI});
            this.put(EntityType.ATTACHMENT, new EntityType[]{EntityType.ATTACHMENT, EntityType.DOCUMENT, EntityType.SPACE, EntityType.WIKI});
            this.put(EntityType.SPACE, new EntityType[]{EntityType.SPACE, EntityType.WIKI});
            this.put(EntityType.OBJECT, new EntityType[]{EntityType.OBJECT, EntityType.DOCUMENT, EntityType.SPACE, EntityType.WIKI});
            this.put(EntityType.OBJECT_PROPERTY, new EntityType[]{EntityType.OBJECT_PROPERTY, EntityType.OBJECT, EntityType.DOCUMENT, EntityType.SPACE, EntityType.WIKI});
            this.put(EntityType.CLASS_PROPERTY, new EntityType[]{EntityType.CLASS_PROPERTY, EntityType.DOCUMENT, EntityType.SPACE, EntityType.WIKI});
        }
    };
    @Inject
    @Named(value="current")
    private EntityReferenceValueProvider currentEntityReferenceValueProvider;

    public EntityReference resolve(String entityReferenceRepresentation, EntityType type, Object ... parameters) {
        String entityName;
        EntityType[] entityTypesForType = ENTITY_TYPES.get(type);
        if (entityTypesForType == null) {
            throw new RuntimeException("No parsing definition found for Entity Type [" + type + "]");
        }
        EntityReference entityReference = null;
        int entityTypeOffset = 0;
        int offset = entityReferenceRepresentation.length() - 1;
        while (offset >= 0 && entityTypeOffset < entityTypesForType.length) {
            StringBuilder entityName2 = new StringBuilder();
            offset = this.readEntityName(entityReferenceRepresentation, entityName2, offset);
            EntityReference parent = new EntityReference(entityName2.reverse().toString(), entityTypesForType[entityTypeOffset++]);
            entityReference = entityReference == null ? parent : entityReference.appendParent(parent);
        }
        for (int i = entityTypeOffset; i < entityTypesForType.length && (entityName = this.resolveDefaultValue(entityTypesForType[i], parameters)) != null; ++i) {
            EntityReference parent = new EntityReference(entityName, entityTypesForType[i]);
            entityReference = entityReference == null ? parent : entityReference.appendParent(parent);
        }
        return entityReference;
    }

    private int readCharacter(String input, StringBuilder output, int offset) {
        if (offset >= 0) {
            char c = input.charAt(offset);
            if (c == '.') {
                if (offset == 0 || offset > 0 && input.charAt(offset - 1) != '.') {
                    return offset;
                }
                output.append(c);
                return offset - 2;
            }
            output.append(c);
            return offset - 1;
        }
        return offset;
    }

    private int readEntityName(String input, StringBuilder output, int inputOffset) {
        int oldOffset;
        int offset = inputOffset;
        do {
            oldOffset = offset;
        } while ((offset = this.readCharacter(input, output, offset)) != oldOffset);
        return offset - 1;
    }

    private String resolveDefaultValue(EntityType type, Object ... parameters) {
        EntityReference referenceParameter;
        EntityReference extractedReference;
        if (parameters.length > 0 && parameters[0] instanceof EntityReference && (extractedReference = (referenceParameter = (EntityReference)parameters[0]).extractReference(type)) != null) {
            return extractedReference.getName();
        }
        return this.getDefaultValue(type, parameters);
    }

    private String getDefaultValue(EntityType type, Object ... parameters) {
        return this.currentEntityReferenceValueProvider.getDefaultValue(type);
    }
}

