/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.event.ApplicationReadyEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.search.solr.internal.api.SolrConfiguration;
import org.xwiki.search.solr.internal.api.SolrIndexer;
import org.xwiki.search.solr.internal.api.SolrIndexerException;
import org.xwiki.search.solr.internal.job.IndexerRequest;

@Component
@Named(value="solr.initializer")
@Singleton
public class SolrIndexInitializeListener
implements EventListener {
    private static final List<Event> EVENTS = Arrays.asList(new ApplicationReadyEvent());
    @Inject
    protected Logger logger;
    @Inject
    private Provider<SolrIndexer> solrIndexer;
    @Inject
    private SolrConfiguration configuration;

    public List<Event> getEvents() {
        return EVENTS;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public void onEvent(Event event, Object source, Object data) {
        if (this.configuration.synchronizeAtStartup()) {
            IndexerRequest request = new IndexerRequest();
            request.setId(Arrays.asList("solr", "indexer"));
            try {
                ((SolrIndexer)this.solrIndexer.get()).startIndex(request);
            }
            catch (SolrIndexerException e) {
                this.logger.error("Failed to start initial Solr index synchronization", (Throwable)e);
            }
        }
    }
}

