/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.internal.metadata;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObjectReference;
import com.xpn.xwiki.objects.BaseProperty;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.solr.common.SolrInputDocument;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.ObjectPropertyReference;
import org.xwiki.search.solr.internal.api.FieldUtils;
import org.xwiki.search.solr.internal.metadata.AbstractSolrMetadataExtractor;
import org.xwiki.search.solr.internal.metadata.LengthSolrInputDocument;
import org.xwiki.search.solr.internal.reference.SolrReferenceResolver;

@Component
@Named(value="object_property")
@Singleton
public class ObjectPropertySolrMetadataExtractor
extends AbstractSolrMetadataExtractor {
    @Inject
    @Named(value="object_property")
    private SolrReferenceResolver resolver;

    @Override
    public boolean setFieldsInternal(LengthSolrInputDocument solrDocument, EntityReference entityReference) throws Exception {
        ObjectPropertyReference objectPropertyReference = new ObjectPropertyReference(entityReference);
        BaseObjectReference objectReference = new BaseObjectReference(objectPropertyReference.getParent());
        DocumentReference classReference = objectReference.getXClassReference();
        DocumentReference documentReference = new DocumentReference(objectReference.getParent());
        XWikiDocument document = this.getDocument(documentReference);
        BaseProperty objectProperty = document.getXObjectProperty(objectPropertyReference);
        if (objectProperty == null) {
            return false;
        }
        solrDocument.setField("class", this.localSerializer.serialize((EntityReference)classReference, new Object[0]));
        solrDocument.setField("number", objectReference.getObjectNumber());
        solrDocument.setField("propertyname", objectPropertyReference.getName());
        this.setLocaleAndContentFields(documentReference, solrDocument, (BaseProperty<ObjectPropertyReference>)objectProperty);
        return true;
    }

    protected void setLocaleAndContentFields(DocumentReference documentReference, SolrInputDocument solrDocument, BaseProperty<ObjectPropertyReference> objectProperty) throws Exception {
        for (Locale documentLocale : this.getLocales(documentReference, null)) {
            solrDocument.addField("locales", (Object)documentLocale);
            solrDocument.setField(FieldUtils.getFieldName("propertyvalue", documentLocale), objectProperty.getValue());
        }
        solrDocument.setField(FieldUtils.getFieldName("propertyvalue", null), objectProperty.getValue());
    }
}

