/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.search.solr.script;

import com.xpn.xwiki.XWikiContext;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.script.service.ScriptService;
import org.xwiki.search.solr.internal.api.SolrIndexer;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="solr")
public class SolrIndexScriptService
implements ScriptService {
    public static final String CONTEXT_LASTEXCEPTION = "lastexception";
    @Inject
    private Logger logger;
    @Inject
    private SolrIndexer solrIndexer;
    @Inject
    private AuthorizationManager authorization;
    @Inject
    private Provider<XWikiContext> xcontextProvider;

    public void index(EntityReference reference) {
        this.clearException();
        try {
            this.checkAccessToWikiIndex(reference);
            this.solrIndexer.index(reference, true);
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    public void index(List<EntityReference> references) {
        this.clearException();
        try {
            this.checkAccessToWikiIndex(references);
            for (EntityReference reference : references) {
                this.solrIndexer.index(reference, true);
            }
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    public void delete(EntityReference reference) {
        this.clearException();
        try {
            this.checkAccessToWikiIndex(reference);
            this.solrIndexer.delete(reference, true);
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    public void delete(List<EntityReference> references) {
        this.clearException();
        try {
            this.checkAccessToWikiIndex(references);
            for (EntityReference reference : references) {
                this.solrIndexer.delete(reference, true);
            }
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    public int getQueueSize() {
        return this.solrIndexer.getQueueSize();
    }

    private void error(String errorMessage, Exception e) {
        String errorMessageToLog = errorMessage;
        if (errorMessageToLog == null) {
            errorMessageToLog = e.getMessage();
        }
        this.logger.error(errorMessageToLog, (Throwable)e);
        ((XWikiContext)this.xcontextProvider.get()).put((Object)CONTEXT_LASTEXCEPTION, (Object)e);
    }

    private void error(Exception e) {
        this.error(null, e);
    }

    private void clearException() {
        ((XWikiContext)this.xcontextProvider.get()).remove((Object)CONTEXT_LASTEXCEPTION);
    }

    private void checkAccessToWikiIndex(EntityReference reference) throws IllegalAccessException {
        EntityReference wikiReference = reference.extractReference(EntityType.WIKI);
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        DocumentReference userReference = xcontext.getUserReference();
        DocumentReference programmingUserReference = xcontext.getDoc().getContentAuthorReference();
        if (!this.authorization.hasAccess(Right.ADMIN, userReference, wikiReference) || !this.authorization.hasAccess(Right.PROGRAM, programmingUserReference, wikiReference)) {
            throw new IllegalAccessException(String.format("The user '%s' is not allowed to alter the index for the entity '%s'", userReference, reference));
        }
    }

    private void checkAccessToWikiIndex(List<EntityReference> references) throws IllegalAccessException {
        HashSet<EntityReference> representatives = new HashSet<EntityReference>();
        for (EntityReference reference : references) {
            EntityReference wikiReference = reference.extractReference(EntityType.WIKI);
            if (representatives.contains(wikiReference)) continue;
            this.checkAccessToWikiIndex(wikiReference);
            representatives.add(wikiReference);
        }
    }
}

